************************************************************************
*   Subroutine for Opening Data Files
************************************************************************
      subroutine opendata(cycle,height
     &                    ,flagoutr,flagoutf,flagoutj,flagpene,multi)
      implicit double precision(a-z)
      integer flagoutr,flagoutf,flagoutj,flagpene(0:10),multi

*********************************
* Output for multi project mode *
*********************************
      if (multi.ge.1) then
      open(unit=10,file='Output_data/posvelsh.dat'
     &            ,status='replace')
      close(10)
      open(unit=10,file='Output_data/posvelgh.dat'
     &            ,status='replace')
      close(10)
      end if

**********************
* Quantity per cycle *
**********************
      open(unit=10,file='Output_data/swimming_speed.dat'
     &            ,status='unknown')
      write(10,*) '# Swimming Speed'
      write(10,*) '# Cycle'
      write(10,*) '# Swimming Speed'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', height/cycle
      write(10,*) '#'
      write(10,*) '# [m/s]'
      close(10)

      open(unit=10,file='Output_data/stroke_length.dat'
     &            ,status='unknown')
      write(10,*) '# Stroke Length'
      write(10,*) '# Cycle'
      write(10,*) '# Stroke Length'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', height
      write(10,*) '#'
      write(10,*) '# [m]'
      close(10)

      open(unit=10,file='Output_data/direction.dat'
     &            ,status='unknown')
      write(10,*) '# Swimming direction'
      write(10,*) '# Cycle'
      write(10,*) '# Direction'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', 180.0d0/3.141592d0
      write(10,*) '#'
      write(10,*) '# [deg]'
      close(10)

      open(unit=10,file='Output_data/power_efficiency1.dat'
     &            ,status='unknown')
      write(10,*) '# Power Efficiency (1)'
      write(10,*) '# Cycle'
      write(10,*) '# Power Efficiency'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# 1.0'
      write(10,*) '#'
      write(10,*) '#'
      close(10)

      open(unit=10,file='Output_data/power_efficiency2.dat'
     &            ,status='unknown')
      write(10,*) '# Power Efficiency (2)'
      write(10,*) '# Cycle'
      write(10,*) '# Power Efficiency'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# 1.0'
      write(10,*) '#'
      write(10,*) '#'
      close(10)

      open(unit=10,file='Output_data/input_power.dat'
     &            ,status='unknown')
      write(10,*) '# Input Power'
      write(10,*) '# Cycle'
      write(10,*) '# Power'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', 998.0d0*height**5/cycle**3
      write(10,*) '#'
      write(10,*) '# [W]'
      close(10)

      open(unit=10,file='Output_data/output_power1.dat'
     &            ,status='unknown')
      write(10,*) '# Ounput Power'
      write(10,*) '# Cycle'
      write(10,*) '# Power'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', 998.0d0*height**5/cycle**3
      write(10,*) '#'
      write(10,*) '# [W]'
      close(10)

      open(unit=10,file='Output_data/output_power2.dat'
     &            ,status='unknown')
      write(10,*) '# Ounput Power'
      write(10,*) '# Cycle'
      write(10,*) '# Power'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# 1.0'
      write(10,*) '# ', 998.0d0*height**5/cycle**3
      write(10,*) '#'
      write(10,*) '# [W]'
      close(10)

***************
* Penetration *
***************
      if (flagpene(0).eq.1) then
      open(unit=10,file='Output_data/penetration.dat'
     &            ,status='unknown')
      write(10,*) '# This file is results of penetration judging'
      close(10)
      endif

*********************
* Rigid body motion *
*********************
      if (flagoutr.ge.1) then

      open(unit=10,file='Output_data/position_x.dat'
     &            ,status='unknown')
      write(10,*) '# Position (x)'
      write(10,*) '# Time'
      write(10,*) '# Position'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height
      write(10,*) '# [sec]'
      write(10,*) '# [m]'
      close(10)

      open(unit=10,file='Output_data/position_y.dat'
     &            ,status='unknown')
      write(10,*) '# Position (y)'
      write(10,*) '# Time'
      write(10,*) '# Position'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height
      write(10,*) '# [sec]'
      write(10,*) '# [m]'
      close(10)

      open(unit=10,file='Output_data/position_z.dat'
     &            ,status='unknown')
      write(10,*) '# Position (z)'
      write(10,*) '# Time'
      write(10,*) '# Position'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height
      write(10,*) '# [sec]'
      write(10,*) '# [m]'
      close(10)

      open(unit=10,file='Output_data/principal_axis_direction.dat'
     &            ,status='unknown')
      write(10,*) '# Principal axis direcitions'
      write(10,*) '# Time'
      write(10,*) '# Normal vector'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', 1.0d0
      write(10,*) '# ', 1.0d0
      write(10,*) '# [sec]'
      write(10,*) '# [non-dimensional]'
      close(10)

      open(unit=10,file='Output_data/x-y_locus.dat'
     &            ,status='unknown')
      write(10,*) '# x-y Locus'
      write(10,*) '# x'
      write(10,*) '# y'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', height
      write(10,*) '# ', height
      write(10,*) '# [m]'
      write(10,*) '# [m]'
      close(10)

      open(unit=10,file='Output_data/velocity_x.dat'
     &            ,status='unknown')
      write(10,*) '# Velocity (x)'
      write(10,*) '# Time'
      write(10,*) '# Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [m/s]'
      close(10)

       open(unit=10,file='Output_data/velocity_y.dat'
     &            ,status='unknown')
      write(10,*) '# Velocity (y)'
      write(10,*) '# Time'
      write(10,*) '# Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [m/s]'
      close(10)

       open(unit=10,file='Output_data/velocity_z.dat'
     &            ,status='unknown')
      write(10,*) '# Velocity (z)'
      write(10,*) '# Time'
      write(10,*) '# Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [m/s]'
      close(10)

       open(unit=10,file='Output_data/angular_velocity_1.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Velocity (Axis1)'
      write(10,*) '# Time'
      write(10,*) '# Angular Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s]'
      close(10)

       open(unit=10,file='Output_data/angular_velocity_2.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Velocity (Axis2)'
      write(10,*) '# Time'
      write(10,*) '# Angular Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s]'
      close(10)

       open(unit=10,file='Output_data/angular_velocity_3.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Velocity (Axis3)'
      write(10,*) '# Time'
      write(10,*) '# Angular Velocity'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s]'
      close(10)

      open(unit=10,file='Output_data/acceleration_x.dat'
     &            ,status='unknown')
      write(10,*) '# Acceleration (x)'
      write(10,*) '# Time'
      write(10,*) '# Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [m/s^2]'
      close(10)

      open(unit=10,file='Output_data/acceleration_y.dat'
     &            ,status='unknown')
      write(10,*) '# Acceleration (y)'
      write(10,*) '# Time'
      write(10,*) '# Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [m/s^2]'
      close(10)

      open(unit=10,file='Output_data/acceleration_z.dat'
     &            ,status='unknown')
      write(10,*) '# Acceleration (z)'
      write(10,*) '# Time'
      write(10,*) '# Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', height/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [m/s^2]'
      close(10)

       open(unit=10,file='Output_data/angular_acceleration_1.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Acceleration (Axis1)'
      write(10,*) '# Time'
      write(10,*) '# Angular Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s^2]'
      close(10)

       open(unit=10,file='Output_data/angular_acceleration_2.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Acceleration (Axis2)'
      write(10,*) '# Time'
      write(10,*) '# Angular Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s^2]'
      close(10)

       open(unit=10,file='Output_data/angular_acceleration_3.dat'
     &            ,status='unknown')
      write(10,*) '# Angular Acceleration (Axis3)'
      write(10,*) '# Time'
      write(10,*) '# Angular Acceleration'
      write(10,*) '# 1'
      write(10,*) '#'
      write(10,*) '# ', cycle
      write(10,*) '# ', 180.0d0/3.14159265358979d0/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [deg/s^2]'
      close(10)

      end if

***************************
* Force, Moment and Power *
***************************

      if (flagoutf.ge.1) then
* Force (x)
       open(unit=10
     &     ,file='Output_data/force_x_000whole_body_with_am2.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_x_000whole_body_with_am.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_x_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Whole Body'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Trunk with Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Lower Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Upper Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Lower Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Upper Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Shoulder'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Neck'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Upper Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Lower Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Right Hand'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_x_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (x) on Left Hand'
      call fheadwri(cycle,height)

* Force (y)
       open(unit=10
     &     ,file='Output_data/force_y_000whole_body_with_am2.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_y_000whole_body_with_am.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_y_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Whole Body'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Trunk with Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Lower Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Upper Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Lower Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Upper Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Shoulder'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Neck'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Upper Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Lower Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Right Hand'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_y_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (y) on Left Hand'
      call fheadwri(cycle,height)

* Force (z)
       open(unit=10
     &     ,file='Output_data/force_z_000whole_body_with_am2.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_z_000whole_body_with_am.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Whole Body with Added Mass'
      call fheadwr2(cycle,height)

       open(unit=10,file='Output_data/force_z_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Whole Body'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Trunk with Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Upper Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Lower Limb'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Lower Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Upper Waist'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Lower Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Upper Breast'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Shoulder'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Neck'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Head'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Upper Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Lower Hip'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Thigh'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Shank'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Foot'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Upper Arm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Forearm'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Right Hand'
      call fheadwri(cycle,height)

       open(unit=10,file='Output_data/force_z_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Fluid Force (z) on Left Hand'
      call fheadwri(cycle,height)

* Moment (1)
       open(unit=10,file=
     &'Output_data/moment_1_000whole_body_with_am.dat',status='unknown')
      write(10,*) '# Moment (Axis1) on Whole Body with Added Mass'
      call mheadwr2(cycle,height)

       open(unit=10,file='Output_data/moment_1_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Whole Body'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Trunk with Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Lower Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Upper Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Lower Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Upper Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Shoulder'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Neck'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Upper Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Lower Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Right Hand'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_1_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis1) on Left Hand'
      call mheadwri(cycle,height)

* Moment (2)
       open(unit=10,file=
     &'Output_data/moment_2_000whole_body_with_am.dat',status='unknown')
      write(10,*) '# Moment (Axis2) on Whole Body with Added Mass'
      call mheadwr2(cycle,height)

       open(unit=10,file='Output_data/moment_2_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Whole Body'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Trunk with Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Lower Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Upper Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Lower Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Upper Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Shoulder'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Neck'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Upper Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Lower Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Right Hand'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_2_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis2) on Left Hand'
      call mheadwri(cycle,height)

* Moment (3)
       open(unit=10,file=
     &'Output_data/moment_3_000whole_body_with_am.dat',status='unknown')
      write(10,*) '# Moment (Axis3) on Whole Body with Added Mass'
      call mheadwr2(cycle,height)

       open(unit=10,file='Output_data/moment_3_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Whole Body'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Trunk with Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Upper Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Lower Limb'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Lower Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Upper Waist'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Lower Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Upper Breast'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Shoulder'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Neck'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Head'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Upper Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Lower Hip'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Thigh'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Shank'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Foot'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Upper Arm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Forearm'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Right Hand'
      call mheadwri(cycle,height)

       open(unit=10,file='Output_data/moment_3_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Moment (Axis3) on Left Hand'
      call mheadwri(cycle,height)

* Power (x)
       open(unit=10,file='Output_data/power_x_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Whole Body'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Trunk with Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Lower Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Upper Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Lower Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Upper Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Shoulder'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Neck'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Upper Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Lower Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Right Hand'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_x_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (x) on Left Hand'
      call pheadwri(cycle,height)

* Power (y)
       open(unit=10,file='Output_data/power_y_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Whole Body'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Trunk with Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Lower Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Upper Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Lower Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Upper Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Shoulder'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Neck'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Upper Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Lower Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Right Hand'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_y_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (y) on Left Hand'
      call pheadwri(cycle,height)

* Power (z)
       open(unit=10,file='Output_data/power_z_000whole_body.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Whole Body'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_001trunk_with_head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Trunk with Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_002right_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_003left_upper_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Upper Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_004right_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_005left_lower_limb.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Lower Limb'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Lower Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Upper Waist'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Lower Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Upper Breast'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Shoulder'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Neck'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Head'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Upper Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Lower Hip'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Thigh'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Shank'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Foot'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Upper Arm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Forearm'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Right Hand'
      call pheadwri(cycle,height)

       open(unit=10,file='Output_data/power_z_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Power (z) on Left Hand'
      call pheadwri(cycle,height)

      end if

****************
* Joint torque *
****************

      if (flagoutj.ge.1) then
* x
       open(unit=10,file='Output_data/joint_torque_x_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_x_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_x_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_x_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_x_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_x_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_x_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_x_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (x) at Root of Left Hand'
      call jheadwri(cycle,height)

* y
       open(unit=10,file='Output_data/joint_torque_y_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_y_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_y_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_y_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_y_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_y_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_y_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_y_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (y) at Root of Left Hand'
      call jheadwri(cycle,height)

* z
       open(unit=10,file='Output_data/joint_torque_z_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_z_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_z_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_z_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_z_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_z_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_z_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_z_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (z) at Root of Left Hand'
      call jheadwri(cycle,height)

* xb
       open(unit=10,file='Output_data/joint_torque_xb_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_xb_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_xb_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_xb_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_xb_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_xb_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_xb_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_xb_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (xb) at Root of Left Hand'
      call jheadwri(cycle,height)

* yb
       open(unit=10,file='Output_data/joint_torque_yb_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_yb_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_yb_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_yb_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_yb_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_yb_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_yb_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_yb_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (yb) at Root of Left Hand'
      call jheadwri(cycle,height)

* zb
       open(unit=10,file='Output_data/joint_torque_zb_01lower_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Lower Waist'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_02upper_waist.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Upper Waist'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_zb_03lower_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Lower Breast'
      call jheadwri(cycle,height)

       open(unit=10
     6     ,file='Output_data/joint_torque_zb_04upper_breast.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Upper Breast'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_05shoulder.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Shoulder'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_06neck.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Neck'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_07head.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Head'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_08upper_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Upper Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_09lower_hip.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Lower Hip'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_10right_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_11left_thigh.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Thigh'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_12right_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_13left_shank.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Shank'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_14right_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Foot'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_15left_foot.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Foot'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_zb_16right_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_zb_17left_upper_arm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Upper Arm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_zb_18right_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Forearm'
      call jheadwri(cycle,height)

       open(unit=10
     &     ,file='Output_data/joint_torque_zb_19left_forearm.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Forearm'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_20right_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Right Hand'
      call jheadwri(cycle,height)

       open(unit=10,file='Output_data/joint_torque_zb_21left_hand.dat'
     &            ,status='unknown')
      write(10,*) '# Joint Torque (zb) at Root of Left Hand'
      call jheadwri(cycle,height)

      end if

      return
      end

**********************
* force header write *
**********************
      subroutine fheadwri(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Force'
      write(10,*) '# 5'
      write(10,*) 
     &   '# All Added_mass Normal_drag Tangential_drag Buoyancy'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**4/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [N]'
      close(10)

      return
      end

      subroutine fheadwr2(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Force'
      write(10,*) '# 5'
      write(10,*) 
     &'# All Added_mass Norm_drag Tangent_drag Buoyancy Added_mass2'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**4/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [N]'
      close(10)

      return
      end

***********************
* moment header write *
***********************
      subroutine mheadwri(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Moment'
      write(10,*) '# 5'
      write(10,*) 
     &   '# All Added_mass Normal_drag Tangential_drag Buoyancy'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**5/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [Nm]'
      close(10)

      return
      end

      subroutine mheadwr2(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Moment'
      write(10,*) '# 5'
      write(10,*) 
     &   '# All Added_mass Norm_drag Tangent_drag Buoyancy Added_mass2'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**5/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [Nm]'
      close(10)

      return
      end

**********************
* power header write *
**********************
      subroutine pheadwri(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Power'
      write(10,*) '# 4'
      write(10,*) 
     &   '# All Added_mass Normal_drag Tangential_drag'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**5/cycle**3
      write(10,*) '# [sec]'
      write(10,*) '# [W]'
      close(10)

      return
      end

*****************************
* joint torque header write *
*****************************
      subroutine jheadwri(cycle,height)
      implicit double precision(a-z)

      write(10,*) '# Time'
      write(10,*) '# Joint Torque'
      write(10,*) '# 3'
      write(10,*) 
     &   '# Average Upper_side Lower_side'
      write(10,*) '# ', cycle
      write(10,*) '# ', 998.0d0*height**5/cycle**2
      write(10,*) '# [sec]'
      write(10,*) '# [Nm]'
      close(10)

      return
      end


