************************************************************************
*                                                                      *
*     Watching program for Multi-project mode                          *
*                                                                      *
*                                           (c) Motomu Nakashima       *
*                                                 since 2009.3.9       *
*                                                                      *
************************************************************************
      implicit double precision (a-z)
      integer cycle,cycle_n,step,step_n,step_n1,rk,i,j,subpro_n
      integer a,asum
      logical(4) result
      character sn1*1, sn2*2
      character*10 chars
      character*16 chars2
      character*30 comchars(0:100)
      character*5 cyclech, stepch, rkch

*******************
* Read input data *
*******************

 1000 format(a10)
 1001 format(a16)

* step_n
      open(unit=23,file='analysis_settings.dat',status='unknown')
      do i=1,10000
          read(23,1000) chars
          if (chars.eq."time_step=") goto 101
      enddo
      write(*,*) "Parameter reading failed!"
      stop
  101 continue
      read(23,*) step_n
      close(23)
      step_n1 = step_n + 1

* cycle_n
      open(unit=23,file='analysis_settings.dat',status='unknown')
      do i=1,10000
          read(23,1000) chars
          if (chars.eq."cycle_num=") goto 102
      enddo
      write(*,*) "Parameter reading failed!"
      stop
  102 continue
      read(23,*) cycle_n
      close(23)

* subpro_n
      open(unit=23,file='analysis_settings.dat',status='unknown')
      do i=1,10000
          read(23,1001) chars2
          if (chars2.eq."num_subprojects=") goto 103
      enddo
      write(*,*) "Parameter reading failed!"
      stop
  103 continue
      read(23,*) subpro_n
      close(23)


******************************************
* Read commands to calculate interaction *
******************************************
  200 format(a30)

*     main project
      open(unit=10,file='../main/CalculateInteraction.dat',
     &     status='unknown')
      read(10,200) comchars(0)
      close(10)

*     sub project(s)
      if (subpro_n.ge.1) then
      do i=1,subpro_n
      if (i.le.9) then
        write(sn1,'(i1)')i
        open(unit=10,file='../sub'//sn1//'/CalculateInteraction.dat',
     &  status='unknown')
      else
        write(sn2,'(i2)')i
        open(unit=10,file='../sub'//sn2//'/CalculateInteraction.dat',
     &  status='unknown')
      endif
      read(10,200) comchars(i)
      close(10)
      enddo
      endif

************************
* Start time step loop *
************************
      do cycle=1,cycle_n
          do step=1,step_n1
              do rk=1,4
                  write(cyclech,'(i5)') cycle
                  write( stepch,'(i5)') step
                  write(   rkch,'(i5)') rk

  300 format("cycle=",i4,"      time step=",i5
     &           ,"      runge-kutta step=",i2)
                  write(*,300) cycle,step,rk

*                 # Wait for all go2.dat become 0
                  do j=1,1000000
                  asum = 0
*                 # main project
 5001             continue
c                     write(*,*) "5001"
                  open(unit=10,file ='../main/go2.dat',action='read'
     &                        ,status='unknown',err=5001)
 5005             continue
                  close(10)
 5006             continue
                  open(unit=10,file ='../main/go2.dat',action='read'
     &                        ,status='unknown',err=5006)
                  a=-1
                  read(10,*,end=5005,err=5005) a
c                 write(*,*) a
                  close(10)
                  asum = asum + a
*                 # sub project(s)
                  if (subpro_n.ge.1) then
                      do i=1,subpro_n
 5002                     continue
c                     write(*,*) "5002"
                          if (i.le.9) then
                          write(sn1,'(i1)')i
                          open(unit=10,file ='../sub'//sn1//'/go2.dat'
     &                        ,action='read',status='unknown',err=5002)
                          else
                          write(sn2,'(i2)')i
                          open(unit=10,file ='../sub'//sn2//'/go2.dat'
     &                        ,action='read',status='unknown',err=5002)
                          endif

 5004                     continue

                          close(10)

 5003                     continue
                          if (i.le.9) then
                          write(sn1,'(i1)')i
                          open(unit=10,file ='../sub'//sn1//'/go2.dat'
     &                        ,action='read',status='unknown',err=5003)
                          else
                          write(sn2,'(i2)')i
                          open(unit=10,file ='../sub'//sn2//'/go2.dat'
     &                        ,action='read',status='unknown',err=5003)
                          endif

                          a=-1

                          read(10,*,end=5004,err=5004) a

c                         write(*,*) a
                          close(10)
                          asum = asum + a
                      enddo
                  endif
                  if (asum.eq.0) then
                  goto 2000
                  endif
c                 write(*,*) "asum", asum

*                 # Wait for a while
                  call sleepqq(1)

                  enddo

 2000             continue

*                 # Calculate interaction among projects
                  if (step.ne.step_n1) then
*                 # main project
 7000             continue
c                 write(*,*) "7000"
                  result = runqq('../main/'//comchars(0)//' '
     &  ,' 0 '//cyclech//' '//stepch//' '//rkch//' ')
*                 # sub project(s)
                    if (subpro_n.ge.1) then
                      do i=1,subpro_n
c                 write(*,*) "7001"
                      if (i.le.9) then
                        write(sn1,'(i1)')i
                        result 
     &                 = runqq('../sub'//sn1//'/'//comchars(i)//' '
     &  ,' '//sn1//' '//cyclech//' '//stepch//' '//rkch//' ')
                      else
                        write(sn2,'(i2)')i
                        result 
     &                 = runqq('../sub'//sn2//'/'//comchars(i)//' '
     &  ,' '//sn2//' '//cyclech//' '//stepch//' '//rkch//' ')
                      endif
                      enddo
                    endif
                  endif
c                 write(*,*) "7002"


*                 # Overwrite go.dat and go2.dat as "-1"
*                 # for main project
 4020             continue
c                     write(*,*) "4020"
                  open(unit=10,file='../main/go.dat',status='replace'
     &                        ,err=4020)
 4021             continue
                  write(10,*,err=4021) "-1000 0 0 0"
                  close(10)

 4022             continue
c                     write(*,*) "4022"
                  open(unit=10,file='../main/go2.dat',status='replace'
     &                        ,err=4022)
 4023                     continue
                  write(10,*,err=4023) "-1000 0 0 0"
                  close(10)

*                 # for sub project(s)
                  if (subpro_n.ge.1) then
                      do i=1,subpro_n
 4030                     continue
c                     write(*,*) "4030"
                          if (i.le.9) then
                          write(sn1,'(i1)')i
 4031                     continue
                          open(unit=10,file ='../sub'//sn1//'/go.dat'
     &                         ,status='replace',err=4031)
                          else
                          write(sn2,'(i2)')i
 4032                     continue
                          open(unit=10,file ='../sub'//sn2//'/go.dat'
     &                        ,status='replace',err=4032)
                          endif
 4033                     continue
                          write(10,*,err=4033) "-1000 0 0 0"
                          close(10)

 4040                     continue
c                     write(*,*) "4040"
                          if (i.le.9) then
                          write(sn1,'(i1)')i
 4041                     continue
                          open(unit=10,file ='../sub'//sn1//'/go2.dat'
     &                         ,status='replace',err=4041)
                          else
                          write(sn2,'(i2)')i
 4042                     continue
                          open(unit=10,file ='../sub'//sn2//'/go2.dat'
     &                        ,status='replace',err=4042)
                          endif
 4043                     continue
                          write(10,*,err=4043) "-1000 0 0 0"
                          close(10)
                      enddo
                  endif

*                 # Wait for a while for stability
c                 call sleepqq(10)

*                 # Overwrite go.dat as "1"
*                 # for main project
 5020             continue
c                     write(*,*) "5020"
                  open(unit=10,file='../main/go.dat',status='replace'
     &                        ,err=5020)
 5021                     continue
c                     write(*,*) "5021"
                  if (step.eq.step_n1) then
                    write(10,*,err=5021) "1 ", cycle, " -1  5"
                  else
                    write(10,*,err=5021) "1 ", cycle, step, rk
                  endif
                  close(10)
*                 # for sub project(s)

                  if (subpro_n.ge.1) then
                      do i=1,subpro_n
 5022                     continue
c                     write(*,*) "5022"
                          if (i.le.9) then
                          write(sn1,'(i1)')i
                          open(unit=10,file ='../sub'//sn1//'/go.dat'
     &                         ,status='replace',err=5022)
                          else
                          write(sn2,'(i2)')i
                          open(unit=10,file ='../sub'//sn2//'/go.dat'
     &                        ,status='replace',err=5022)
                          endif
 5023                     continue
c                     write(*,*) "5023"
                          if (step.eq.step_n1) then
                              write(10,*,err=5023) "1 ",cycle," -1  5"
                          else
                              write(10,*,err=5023) "1 ",cycle,step,rk
                          endif
                          close(10)
                      enddo
                  endif

c                 call sleepqq(1)

                  if (step.eq.step_n1) then
                      goto 8000
                  endif
              enddo
8000      continue
          enddo
      enddo

      stop
      end
