########################################################################
#                                                                      #
#   Animate Motion for Swumsuit                                        #
#                                            since 2005.1.16-          #
#                                            (c) Motomu Nakashima      #
########################################################################

# Setup routine. Open windows, packing, etc...
proc AmSetup {} {
    global startx starty xangle0 yangle0 xangle yangle zangle RotCnt
    global vTime
    global time speed time_incr
    set RotCnt 1
    set xangle 0.0
    set yangle 0.0
    set zangle 0.0
    set vTime 100
    wm withdraw .
    toplevel .am
    wm title .am [pwd]
    wm protocol .am WM_DELETE_WINDOW AmClose

    # judge cogcob.dat exists or not
    global cog_exist
    set cog_exist 0
    if {[file exists Output_data/cogcob.dat]==1} {set cog_exist 1}

    # Togl window (here, only frame)
    frame .am.toglframe -width 600 -height 600

    # Open togl window
    togl .am.togl -width 600 -height 600 -rgba true \
         -double true -depth true -privatecmap false -time 100 
    bind .am.togl <ButtonPress-1> {AmRotStart %x %y %W}
    bind .am.togl <B1-Motion> {AmRotMove %x %y %W}
    bind .am.togl <ButtonPress-3> {AmRotStartZ %y %W}
    bind .am.togl <B3-Motion> {AmRotMoveZ %y %W}
    bind .am.togl <Shift-ButtonPress-1> {AmScaleStart %y %W}
    bind .am.togl <Shift-B1-Motion> {AmScaleMove %y %W}
    place .am.togl -x 1 -y 1

    # Other windows...
    frame .am.panel
    frame .am.panel.force -relief groove -borderwidth 2
    frame .am.panel.force.updown
    frame .am.panel.speed -relief groove -borderwidth 2
    frame .am.panel.speed.updown
    frame .am.panel.scale 
    frame .am.panel.scale.time
    global Output
    button .am.panel.export  -text "$Output" -height 2 \
                   -command AmPopupExportDialog 
    global sourcedir
    button .am.panel.play -bitmap @${sourcedir}/bitmap_play.xbm \
                   -width 50 -height 30  -command AmPlayPause
    global Close
    button .am.panel.exit  -text "$Close" -command AmClose -height 2

     #-length 490 
    scale  .am.panel.scale.scale -orient horizontal \
               -from 1 -to 100 -var time -showvalue false
    label .am.panel.scale.time.label -text "   t* = "
    label .am.panel.scale.time.time  -text "0.001" -width 7 -anchor w

    button .am.panel.force.updown.up \
                     -bitmap @${sourcedir}/bitmap_up.xbm \
                     -command "incr force 1 ; AmChangeForce"
    button .am.panel.force.updown.down \
                     -bitmap @${sourcedir}/bitmap_down.xbm \
                     -command "incr force -1 ; AmChangeForce"
    global Force
    label  .am.panel.force.label -text "${Force}:"
    label  .am.panel.force.ratio -text "x1   " -width 5

    button .am.panel.speed.updown.up \
              -bitmap @${sourcedir}/bitmap_up.xbm \
              -command "incr speed 1 ; AmSetTimeIncr"
    button .am.panel.speed.updown.down \
              -bitmap @${sourcedir}/bitmap_down.xbm \
              -command "incr speed -1 ; AmSetTimeIncr"
    global Speed
    label  .am.panel.speed.label -text "${Speed}:"
    label  .am.panel.speed.ratio -text "x1   " -width 5

    pack  .am.panel.force.updown.up \
          .am.panel.force.updown.down -side top
    pack  .am.panel.force.label \
          .am.panel.force.ratio \
          .am.panel.force.updown -side left -anchor w

    pack  .am.panel.speed.updown.up \
          .am.panel.speed.updown.down -side top
    pack  .am.panel.speed.label  \
          .am.panel.speed.ratio .am.panel.speed.updown -side left 

    pack  .am.panel.speed.updown -side left 
    pack  .am.panel.force.updown -side left 

    pack  .am.panel.scale.time.label -side left -anchor w
    pack  .am.panel.scale.time.time -side left -fill x
    pack  .am.panel.scale.scale -side left -expand 1 -fill x
    pack  .am.panel.scale.time -side right

    # panel2 (for rotation angle, "all or last" , and sync graph)
    frame .am.panel.panel2 -bd 2 -relief groove

    # rotation
    global Rotation_angle
    label  .am.panel.panel2.l1 -text $Rotation_angle
    entry  .am.panel.panel2.e1 -textvariable xangle -width 7
    entry  .am.panel.panel2.e2 -textvariable yangle -width 7
    entry  .am.panel.panel2.e3 -textvariable zangle -width 7
    bind   .am.panel.panel2.e1 <Key-Return> AmEntryRotate
    bind   .am.panel.panel2.e2 <Key-Return> AmEntryRotate
    bind   .am.panel.panel2.e3 <Key-Return> AmEntryRotate
    global Apply
    button .am.panel.panel2.b  -text $Apply \
                  -command "AmEntryRotate ; AmEntryScale"

    # magnify
    global Magnify
    label  .am.panel.panel2.l4 -text $Magnify
    entry  .am.panel.panel2.e4 -textvariable glscale -width 7
    bind   .am.panel.panel2.e4 <Key-Return> AmEntryScale

    # "all or last" selection
    global All Last
    global amallorlast
    radiobutton .am.panel.panel2.r1 -variable amallorlast -value all \
                                    -text $All
    radiobutton .am.panel.panel2.r2 -variable amallorlast -value last \
                                    -text $Last
    pack .am.panel.panel2.r2 \
         .am.panel.panel2.r1 \
              -side right 

    # sync graph
    global Sync_graph
    checkbutton .am.panel.panel2.sg -variable syncgraph \
           -text "$Sync_graph"

    # panel2 packing
    pack   .am.panel.panel2.l1 \
           .am.panel.panel2.e1 \
           .am.panel.panel2.e2 \
           .am.panel.panel2.e3 \
           .am.panel.panel2.l4 \
           .am.panel.panel2.e4 \
           .am.panel.panel2.b \
                -side left
    pack   .am.panel.panel2.sg  -side left -padx 15


    frame .am.panel.panel3 -bd 0
    frame .am.panel.panel3.f1 -bd 0
    frame .am.panel.panel3.f2 -bd 0

    global COG 
    checkbutton .am.panel.panel3.f1.1 -variable cog_display -text "$COG"
    if {$cog_exist==1} {
        pack .am.panel.panel3.f1.1 -side right -padx 0 -pady 0
    }

    # for multi project mode
    global multi
    if {$multi != 0} {
    global Color_coding Each_sub Main_or_sub None
    global col_code
    label .am.panel.panel3.f1.t -text " $Color_coding "
    radiobutton .am.panel.panel3.f2.1 -variable col_code -value 2 \
                                   -text " $Each_sub  "
    radiobutton .am.panel.panel3.f2.2 -variable col_code -value 1 \
                                   -text " $Main_or_sub  "
    radiobutton .am.panel.panel3.f2.3 -variable col_code -value 0 \
                                   -text " $None"

    pack .am.panel.panel3.f1.t  -side left -pady 0 
    pack .am.panel.panel3.f2.1  -side left -pady 0 -padx 0
    pack .am.panel.panel3.f2.2  -side left -pady 0 -padx 0
    pack .am.panel.panel3.f2.3  -side left -pady 0 -padx 0
    }
    pack .am.panel.panel3.f1 -side top -pady 0 -fill x
    pack .am.panel.panel3.f2 -side top -pady 0

    # panel packing
    pack .am.panel.scale -side top -fill x
    pack .am.panel.panel2 -side top -fill x
    pack .am.panel.play -side left -padx 0
    pack .am.panel.export -side left -padx 0
    pack .am.panel.exit -side right -padx 0
    pack .am.panel.force .am.panel.speed -side right

    # all packing
    pack .am.toglframe .am.panel -side top -fill x
    # for multi project mode
    # if {$multi != 0} {
    pack .am.panel.panel3 -side right -pady 0 -padx 4
    # }

    ChangeIcon .am
}

proc AmRotStart {x y W } {
    global startx starty xangle0 yangle0 xangle yangle
	set startx $x
	set starty $y
        set vPos [$W position]
	set xangle0 [lindex $vPos 0]
	set yangle0 [lindex $vPos 1]
}

proc AmRotStartZ {y W } {
    global startz zangle0 zangle
	set startz $y
        set vPos [$W positionz]
	set zangle0 [lindex $vPos 0]
}

proc AmScaleStart {y W } {
    global starts sangle0
	set starts $y
        set vPos [$W positions]
	set sangle0 [lindex $vPos 0]
}

proc AmRotMove {x y W} {
    global startx starty xangle0 yangle0 xangle yangle
    set xangle [expr $xangle0 + ($x - $startx)  ]
    set yangle [expr $yangle0 + ($y - $starty)  ]
    $W rotate $xangle $yangle
}

proc AmRotMoveZ {y W} {
    global startz zangle0 zangle
    set zangle [expr $zangle0 + ($y - $startz)  ]
    $W rotatez $zangle
}

proc AmScaleMove {y W} {
    global starts sangle0 glscale
    set glscale [expr $sangle0 - 0.01 * ($y - $starts) ]
    if {$glscale<=0.0} { set glscale 0.01 }
    $W scalechange $glscale
}

proc AmEntryRotate {} {
    global xangle yangle zangle
    .am.togl rotate  $xangle $yangle
    .am.togl rotatez $zangle
}

proc AmEntryScale {} {
    global glscale
    .am.togl scalechange $glscale
}

proc AmChangeForce { } {
    global force fscale 
        set fscale [expr 50.0 * double(pow(2,$force))]
        .am.togl fchange $fscale
        if { $force >= 0 } {
            .am.panel.force.ratio configure \
                      -text "x[expr int(pow(2,$force))]   "
        } else {
            .am.panel.force.ratio configure \
                      -text "x1/[expr int(pow(2,-$force))]"
        }
}

proc AmPlayPause { } {
    global time_incr
    if { $time_incr != 0 } then {
        set time_incr 0
    } else {
        AmSetTimeIncr
    }
}

proc AmSetTimeIncr { } {
    global time_incr time_interval speed
    if { $speed > 0.5 } then {
        #set time_incr [expr $speed+1]
        set time_incr [expr int(pow(2,$speed)) ]
        set time_interval 0
        .am.panel.speed.ratio configure \
                     -text "x[expr int(pow(2,$speed))]   "
    } elseif { $speed < -0.5 } {
        set time_incr 1
        set time_interval [expr int(10*pow(2,(-$speed-1)))]
        .am.panel.speed.ratio configure \
                     -text "x1/[expr int(pow(2,-$speed))]"
    } else {
        set time_incr 1
        set time_interval 0
        .am.panel.speed.ratio configure -text "x1   "
    }
}

proc AmAnimate { } {
    global time time_incr nondtime time_interval numl2
    global sloop lloop amallorlast output_image
    global multi num_subprojects col_code
    global cog_exist cog_display
    set lastloop ""

    if {$output_image==1} { StartOutputImage }

    for { set j 1 } { $j <= 1000000000000000 } { incr j } {
    for { set loop $sloop } { $loop <= $lloop } { incr loop } {

    # load data
    if {$amallorlast=="last"} { set loop $lloop }
    if {$loop!=$lastloop} {
        .am.togl loaddata [expr $loop-$sloop +1] $multi $num_subprojects $cog_exist
    }
    set lastloop $loop

    # loop
    for { set time 1 } { $time <= [expr $numl2-1] } \
        { incr time $time_incr} {
       if {$time_incr=="-1"} { return }

       set nondtime [expr (double($time)-1.0)/double($numl2)+$loop-1.0]
       .am.togl advancetime [expr $time-1] $col_code $cog_display
       .am.panel.scale.time.time configure \
                     -text [string range $nondtime 0 5]

           # to sync graph 
           global syncgraph
           if {$syncgraph=="1"} {
               set openfile [open time_sync.dat w]
               puts $openfile $nondtime
               close $openfile
           }

       update
       after $time_interval

       # sleep for pause
       if {$time_incr=="0"} { after 30 }

       # Output image
       if {$output_image==1} { OutputImage $loop $time}
    }
       incr time 1
       .am.togl advancetime [expr $time-1] $col_code $cog_display
       update
       after $time_interval
       # Output image
       if {$output_image==1} { OutputImage $loop $time}
    }
       if {$output_image==1} { FinishOutputImage }
    }
}

proc AmFolderOpen { } {
    global numl2 sloop lloop amallorlast

    # load "numl2" and related scripts
    set openfile [open Output_data/motion.dat r]
    gets $openfile line
    close $openfile
    set numl2 [lindex $line 0]
    set sloop  [lindex $line 1]
    set lloop  [lindex $line 2]
    .am.panel.scale.scale configure -to $numl2

    if {$sloop==$lloop} {
        set amallorlast last
        .am.panel.panel2.r1 configure -state disabled
        #.am.panel.panel2.l2 configure -state disabled
    } else {
        set amallorlast all
        .am.panel.panel2.r1 configure -state normal
        #.am.panel.panel2.l2 configure -state normal
    }
    # Start animation
    AmAnimate
}


proc AmPopupExportDialog { } {

    # pause animation
    global time_incr
    set time_incr 0

    if {[winfo exists .am.output]==0} {
        toplevel .am.output
        wm title .am.output "Swumsuit: Output Images"

        global img_format

        global Format BMP GIF JPEG POSTSCRIPT MPEG
        labelframe .am.output.format -text " $Format "
        radiobutton .am.output.format.bmp \
            -variable img_format -value bmp \
            -text "$BMP" -anchor w
        radiobutton .am.output.format.gif \
            -variable img_format -value gif \
            -text "$GIF" -anchor w
        radiobutton .am.output.format.jpg \
            -variable img_format -value jpg \
            -text "$JPEG" -anchor w
        radiobutton .am.output.format.eps \
            -variable img_format -value eps \
            -text "$POSTSCRIPT" -anchor w
        radiobutton .am.output.format.mpg \
            -variable img_format -value mpg \
            -text "$MPEG" -anchor w
        pack \
             .am.output.format.bmp \
             .am.output.format.gif \
             .am.output.format.jpg \
             .am.output.format.eps \
             .am.output.format.mpg \
                 -side top -fill x

        global img_size Size
        labelframe .am.output.size -text " $Size "
        radiobutton .am.output.size.1 \
            -variable img_size -value 1 \
            -text "1/1" -anchor w
        radiobutton .am.output.size.2 \
            -variable img_size -value 2 \
            -text "1/2" -anchor w
        radiobutton .am.output.size.4 \
            -variable img_size -value 4 \
            -text "1/4" -anchor w
        pack \
             .am.output.size.1 \
             .am.output.size.2 \
             .am.output.size.4 \
                 -side top -fill x

        global output_type 

        global Output_type All_cycles Last_cycle This_moment
        labelframe .am.output.type -text " $Output_type "
        radiobutton .am.output.type.allcycles \
            -variable output_type -value all_cycles \
            -text "$All_cycles" -anchor w
        global sloop lloop
        if {$sloop==$lloop} {
            .am.output.type.allcycles configure -state disabled
        }
        radiobutton .am.output.type.lastcycle \
            -variable output_type -value last_cycle \
            -text "$Last_cycle" -anchor w
        radiobutton .am.output.type.thismoment \
            -variable output_type -value this_moment \
            -text "$This_moment" -anchor w
        pack \
             .am.output.type.allcycles \
             .am.output.type.lastcycle \
             .am.output.type.thismoment \
                 -side top -fill x

        frame .am.output.panel
        global OK Cancel
        button .am.output.panel.ok -text "   $OK   " \
            -command ExecuteOutputImage
        button .am.output.panel.cancel -text " $Cancel " \
            -command "wm withdraw .am.output"
        pack .am.output.panel.ok \
             .am.output.panel.cancel \
               -side left -padx 10 -pady 10 -expand 1

        pack .am.output.format -pady 5 -fill x
        pack .am.output.size           -fill x
        pack .am.output.type   -pady 5 -fill x
        pack .am.output.panel

        ChangeIcon .am.output
    } else {
        wm deiconify .am.output
    }
}


# Execute output image
proc ExecuteOutputImage {} {
    global output_type img_format img_size
    if {$output_type=="this_moment"} {

        # Export image into the "swumview_tmp_img.eps" file.
        .am.togl epsout 

        # Move the file to the Output_images folder.
        if { [file exists Output_images]==0 } {
            file mkdir Output_images
        }
        file copy -force swumview_tmp_img.eps \
                     Output_images/motion_img000_0000.eps
        file delete swumview_tmp_img.eps

        # Convert images
        #
        # first, select image type
        if {$img_format=="bmp"} {
            set EXT "bmp"
        } elseif {$img_format=="gif"} {
            set EXT "gif"
        } elseif {$img_format=="jpg"} {
            set EXT "jpg"
        } elseif {$img_format=="mpg"} {
            set EXT "jpg"
        } else { 
            return
        } 
        # next, select size
        if {$img_size=="1"} {
            set GEO "600x600"
        } elseif {$img_size=="2"} {
            set GEO "300x300"
        } elseif {$img_size=="4"} {
            set GEO "150x150"
        } else { 
            return
        } 

        # save current directory and go to subdirectory
        set Pwd [pwd]
        cd Output_images

        global OS
        if {$OS=="Linux"} {
            set execcommand "exec xterm -e convert -geometry $GEO motion_img000_0000.eps motion_img000_0000.$EXT"
        } else {
            set execcommand "exec cmd.exe /c convert.exe -geometry $GEO motion_img000_0000.eps motion_img000_0000.$EXT"
        }
        eval $execcommand 
        file delete motion_img000_0000.eps

        # recover current directory
        cd $Pwd

	update
        wm withdraw .am.output
    } else {
        global Output_ok
        set a [tk_messageBox -type okcancel -message $Output_ok]
        if {$a=="cancel"} { return }
        global output_image amallorlast
        set output_image 1
        if {$output_type=="last_cycle"} {
            set amallorlast last
        } else {
            set amallorlast all
        }
        wm withdraw .am.output
        update
        AmSetTimeIncr
        AmAnimate
    }
}


# Output image
proc OutputImage { loop time } {
    global output_type img_format img_size

    # Export image into the "swumview_tmp_img.eps" file.
    .am.togl epsout 

    # make file name
    set loop_num "00000$loop"
    set time_num "00000$time"
    set loop_num [string range $loop_num end-2 end]
    set time_num [string range $time_num end-3 end]
    set filename motion_img${loop_num}_${time_num}

    # Move the file to the Output_images folder.
    if { [file exists Output_images]==0 } {
        file mkdir Output_images
    }
    file copy -force swumview_tmp_img.eps \
                 Output_images/${filename}.eps
    file delete swumview_tmp_img.eps

    # Convert images
    #
    if {$img_format!="eps"} {
        # first, select image type
        if {$img_format=="bmp"} {
            set EXT ".bmp"
        } elseif {$img_format=="gif"} {
            set EXT ".gif"
        } elseif {$img_format=="jpg"} {
            set EXT ".jpg"
        } elseif {$img_format=="mpg"} {
            set EXT "_tmp.gif"
        } else { }
        # next, select size
        if {$img_size=="1"} {
            set GEO "600x600"
        } elseif {$img_size=="2"} {
            set GEO "300x300"
        } elseif {$img_size=="4"} {
            set GEO "150x150"
        } else { 
            return
        } 


        # save current directory and go to subdirectory
        set Pwd [pwd]
        cd Output_images

        global OS
        if {$OS=="Linux"} {
            set execcommand "exec xterm -e convert -geometry $GEO ${filename}.eps ${filename}$EXT"
        } else {
            set execcommand "exec cmd.exe /c convert.exe -geometry $GEO ${filename}.eps ${filename}$EXT"
        }
        eval $execcommand
        file delete ${filename}.eps

        # recover current directory
        cd $Pwd
    }

}


# Start output image
proc StartOutputImage {} {

}


# Finish output image
proc FinishOutputImage {} {
    global output_image img_format
    # make mpeg file
    if {$img_format=="mpg"} {
        # save current directory and go to subdirectory
        set Pwd [pwd]
        cd Output_images

        global OS
        if {$OS=="Linux"} {
            set execcommand "exec xterm -e convert *_tmp.gif motion_movie.mpg"
        } else {
            set execcommand "exec cmd.exe /c convert.exe *_tmp.gif motion_movie.mpg"
        }
        catch { eval $execcommand }
        eval file delete [glob -nocomplain *_tmp.gif]

        # recover current directory
        cd $Pwd
        
    }
    set output_image 0
    update
    global Output_finish
    tk_messageBox -type ok -message $Output_finish
}


proc TEMPORARY {} {
    global col_code
    # for "This moment"
    if { $a == 0 } { 
        # Export image into the "swumview_tmp_img.eps" file.
        .am.togl epsout 
	# Move the file to the EPS_Images folder.
	if { [file exists EPS_Images]==0 } { file mkdir EPS_Images }
	eval file delete -force dummy \
	                        [glob -nocomplain EPS_Images/motion_img*.eps]
	file copy -force swumview_tmp_img.eps EPS_Images/motion_img0000.eps
	file delete swumview_tmp_img.eps
	update
    }
    # for "This cycle" 
    if { $a == 1 } { 
	if { [file exists EPS_Images]==0 } { file mkdir EPS_Images }
	eval file delete -force dummy \
	                        [glob -nocomplain EPS_Images/motion_img*.eps]
        # In this case, animate one cycle
        #global time time_incr nondtime numl2
        set time_incr 1
        for { set time 1 } { $time <= $numl2 } { incr time $time_incr} {
           set nondtime [expr (double($time)-1.0)/double($numl2)]
           .am.togl advancetime [expr $time-1] $col_code $cog_display
	   update
           # Export image into the "swumview_tmp_img.eps" file.
           .am.togl epsout 
	   # Set the "zeros" (00, etc.) for the top of the "time"
	   if { [string length $time]==1 } { 
	       set timetop 000
	   } elseif { [string length $time]==2 } {
	       set timetop 00
	   } elseif { [string length $time]==1 } {
	       set timetop 0
	   } else {
	       set timetop ""
	   }
	   file copy -force swumview_tmp_img.eps \
	                            EPS_Images/motion_img$timetop$time.eps
	   file delete swumview_tmp_img.eps
           .am.panel.scale.time.time configure \
                             -text string range $nondtime 0 5]
           update
        }
     }
}



proc AmPopupExportDialogOrg { } {
        global time nondtime numl2 col_code

    # Popup the dialog.
    global Animate_output_setting This_moment_only All Cancel
    set a [tk_dialog .am.d0 "Output setting" \
    $Animate_output_setting  "" 1 $This_moment_only $All $Cancel ]

    # for "This moment"
    if { $a == 0 } { 
        # Export image into the "swumview_tmp_img.eps" file.
        .am.togl epsout 
	# Move the file to the EPS_Images folder.
	if { [file exists EPS_Images]==0 } { file mkdir EPS_Images }
	eval file delete -force dummy \
	                        [glob -nocomplain EPS_Images/motion_img*.eps]
	file copy -force swumview_tmp_img.eps EPS_Images/motion_img0000.eps
	file delete swumview_tmp_img.eps
	update
    }
    # for "This cycle" 
    if { $a == 1 } { 
	if { [file exists EPS_Images]==0 } { file mkdir EPS_Images }
	eval file delete -force dummy \
	                        [glob -nocomplain EPS_Images/motion_img*.eps]
        # In this case, animate one cycle
        #global time time_incr nondtime numl2
        set time_incr 1
        for { set time 1 } { $time <= $numl2 } { incr time $time_incr} {
           set nondtime [expr (double($time)-1.0)/double($numl2)]
           .am.togl advancetime [expr $time-1] $col_code $cog_display
	   update
           # Export image into the "swumview_tmp_img.eps" file.
           .am.togl epsout 
	   # Set the "zeros" (00, etc.) for the top of the "time"
	   if { [string length $time]==1 } { 
	       set timetop 000
	   } elseif { [string length $time]==2 } {
	       set timetop 00
	   } elseif { [string length $time]==1 } {
	       set timetop 0
	   } else {
	       set timetop ""
	   }
	   file copy -force swumview_tmp_img.eps \
	                            EPS_Images/motion_img$timetop$time.eps
	   file delete swumview_tmp_img.eps
           .am.panel.scale.time.time configure \
                             -text string range $nondtime 0 5]
           update
        }
     }
}


# Close window
proc AmClose {} {
    global time_incr time_incr_org
    set time_incr_org $time_incr
    set time_incr -1
    #wm withdraw .am
    exit 
}


# Starup script
proc AmStart {} {
    # check if dat files exist
    if { [file exists body_geometry.dat]==0 } {
        global No_body_geometry_file
        wm withdraw .
        tk_messageBox -type ok -icon error \
                               -message $No_body_geometry_file
        exit
    }
    if { [file exists Output_data/motion.dat]==0 } {
        global No_motion_file
        wm withdraw .
        tk_messageBox -type ok -icon error \
                               -message $No_motion_file
        exit
    }


    # window setup
    if {[winfo exists .am]==0} {
        AmSetup
    } else {
        wm deiconify .am
    }

    # get time_incr
    global time_incr time_incr_org
    set time_incr $time_incr_org

    # Animation starts
    AmFolderOpen
}


# Change icon
proc ChangeIcon { w } {
    global Platform sourcedir
    if {$Platform=="windows"} {
        update
        wm iconbitmap $w $sourcedir/icon_small.ico
    }
}



##########################################################
# Startup script
##########################################################


# Get sourcedir & dname from arguments
set sourcedir [lindex $argv 0]
set dname     [lindex $argv 1]
set Locale    [lindex $argv 2]
set multi     [lindex $argv 3]
set num_subprojects  [lindex $argv 4]
cd $dname

# Set environment
source $sourcedir/set_environment.tcl
# Set default font
source $sourcedir/set_default_font.tcl
# Load other sources
source $sourcedir/load_catalog.tcl

# load OpenGL library
load $sourcedir/animate_motion[info sharedlibextension]

# global initializing
set speed 0
set time_incr 1
set time_incr_org 1
set time_interval 0
set force 0

set img_format mpg
set img_size 2
set output_type last_cycle
set output_image 0

set glscale 1.0

set col_code 0

# Animate start
AmStart

