########################################################################
#                                                                      #
#  Analysis Settings Editor for Swumsuit                               #
#                                            since 2004.12.10          #
#                                            (c) Motomu Nakashima      #
########################################################################

# Popup selection menu
proc EditAnalysisSettings {} {
    tk_popup .anam [winfo pointerx .] [expr [winfo pointery .]+5]
}


# Calculation setting window
proc EditCalcSettings {} {
    # make window (if does not exist)
    if { [winfo exists .editcs ]==0 } {
        toplevel .editcs
        wm title .editcs "Swumsuit: Edit Calculation Settings"

        frame .editcs.m -relief groove -bd 2

        global Solve Given \
               Center_of_mass_and_principal_axes_of_inertia \
               Velocity_in_x_direction Velocity_in_y_direction \
               Velocity_in_z_direction Angular_velocity_about_x_axis \
               Angular_velocity_about_y_axis \
               Angular_velocity_about_z_axis 
        global comsolv vgxsolv vgysolv vgzsolv \
               ome1solv ome2solv ome3solv

        frame .editcs.d
        global Multi_project_mode Main Sub Off multi
        label .editcs.d.l \
                -text $Multi_project_mode
        radiobutton .editcs.d.r1 -text $Main \
                                   -variable multi -value 2
        radiobutton .editcs.d.r2 -text $Sub \
                                   -variable multi -value 1
        radiobutton .editcs.d.r3 -text $Off \
                                   -variable multi -value 0
        pack .editcs.d.l -side left
        pack .editcs.d.r3 .editcs.d.r2 .editcs.d.r1 -side right
 
        frame .editcs.s
        global Number_of_subprojects
        label .editcs.s.label -text $Number_of_subprojects
        label .editcs.s.colon -text " : "
        entry .editcs.s.entry -textvariable num_subprojects
        pack  .editcs.s.label -side left -anchor w
        pack  .editcs.s.entry \
              .editcs.s.colon \
                -side right

        frame .editcs.b 
        global Consider_conservation Yes No conam
        label .editcs.b.l \
                -text $Consider_conservation
        radiobutton .editcs.b.r1 -text $Yes \
                                   -variable conam -value 1
        radiobutton .editcs.b.r2 -text $No \
                                   -variable conam -value 0
        pack .editcs.b.l -side left
        pack .editcs.b.r2 .editcs.b.r1 -side right

        frame .editcs.0 -relief groove -bd 2
        global Number_of_segments
        label .editcs.0.label -text $Number_of_segments
        label .editcs.0.colon -text " : "
        entry .editcs.0.entry -textvariable numb
        pack  .editcs.0.label -side left -anchor w
        pack  .editcs.0.entry \
              .editcs.0.colon \
                -side right

        frame .editcs.m.1 
        label .editcs.m.1.l \
                -text $Center_of_mass_and_principal_axes_of_inertia
        radiobutton .editcs.m.1.r1 -text $Solve \
                                   -variable comsolv -value 1
        radiobutton .editcs.m.1.r2 -text $Given \
                                   -variable comsolv -value 0
        pack .editcs.m.1.l -side left
        pack .editcs.m.1.r2 .editcs.m.1.r1 -side right
        pack .editcs.m.1 -side top -fill x

        frame .editcs.m.2 
        label .editcs.m.2.l \
                -text $Velocity_in_x_direction
        radiobutton .editcs.m.2.r1 -text $Solve \
                                   -variable vgxsolv -value 1
        radiobutton .editcs.m.2.r2 -text $Given \
                                   -variable vgxsolv -value 0
        pack .editcs.m.2.l -side left
        pack .editcs.m.2.r2 .editcs.m.2.r1 -side right
        pack .editcs.m.2 -side top -fill x

        frame .editcs.m.3 
        label .editcs.m.3.l \
                -text $Velocity_in_y_direction
        radiobutton .editcs.m.3.r1 -text $Solve \
                                   -variable vgysolv -value 1
        radiobutton .editcs.m.3.r2 -text $Given \
                                   -variable vgysolv -value 0
        pack .editcs.m.3.l -side left
        pack .editcs.m.3.r2 .editcs.m.3.r1 -side right
        pack .editcs.m.3 -side top -fill x

        frame .editcs.m.4 
        label .editcs.m.4.l \
                -text $Velocity_in_z_direction
        radiobutton .editcs.m.4.r1 -text $Solve \
                                   -variable vgzsolv -value 1
        radiobutton .editcs.m.4.r2 -text $Given \
                                   -variable vgzsolv -value 0
        pack .editcs.m.4.l -side left
        pack .editcs.m.4.r2 .editcs.m.4.r1 -side right
        pack .editcs.m.4 -side top -fill x

        frame .editcs.m.5 
        label .editcs.m.5.l \
                -text $Angular_velocity_about_x_axis
        radiobutton .editcs.m.5.r1 -text $Solve \
                                   -variable ome1solv -value 1
        radiobutton .editcs.m.5.r2 -text $Given \
                                   -variable ome1solv -value 0
        pack .editcs.m.5.l -side left
        pack .editcs.m.5.r2 .editcs.m.5.r1 -side right
        pack .editcs.m.5 -side top -fill x

        frame .editcs.m.6 
        label .editcs.m.6.l \
                -text $Angular_velocity_about_y_axis
        radiobutton .editcs.m.6.r1 -text $Solve \
                                   -variable ome2solv -value 1
        radiobutton .editcs.m.6.r2 -text $Given \
                                   -variable ome2solv -value 0
        pack .editcs.m.6.l -side left
        pack .editcs.m.6.r2 .editcs.m.6.r1 -side right
        pack .editcs.m.6 -side top -fill x

        frame .editcs.m.7 
        label .editcs.m.7.l \
                -text $Angular_velocity_about_z_axis
        radiobutton .editcs.m.7.r1 -text $Solve \
                                   -variable ome3solv -value 1
        radiobutton .editcs.m.7.r2 -text $Given \
                                   -variable ome3solv -value 0
        pack .editcs.m.7.l -side left
        pack .editcs.m.7.r2 .editcs.m.7.r1 -side right
        pack .editcs.m.7 -side top -fill x


        frame .editcs.1
        global Actual_time_for_one_cycle
        label .editcs.1.label -text $Actual_time_for_one_cycle
        label .editcs.1.colon -text " : "
        global cycle
        entry .editcs.1.entry -textvariable cycle
        pack  .editcs.1.label -side left -anchor w
        pack  .editcs.1.entry \
              .editcs.1.colon \
                -side right

        frame .editcs.2
        #global Actual_human_height
        global Drag_in_gliding
        #label .editcs.2.label -text $Actual_human_height
        label .editcs.2.label -text $Drag_in_gliding
        label .editcs.2.colon -text " : "
        entry .editcs.2.entry -textvariable drag_gli
        pack  .editcs.2.label -side left -anchor w
        pack  .editcs.2.entry \
              .editcs.2.colon \
                -side right

        frame .editcs.c -relief groove -bd 2
        frame .editcs.c.3
        global Fluid_force_coefficient_cn
        label .editcs.c.3.label -text $Fluid_force_coefficient_cn
        label .editcs.c.3.colon -text " : "
        entry .editcs.c.3.entry -textvariable cn(1)
        pack  .editcs.c.3.label -side left -anchor w
        pack  .editcs.c.3.entry \
              .editcs.c.3.colon \
                -side right

        frame .editcs.c.4
        global Fluid_force_coefficient_ct
        label .editcs.c.4.label -text $Fluid_force_coefficient_ct
        label .editcs.c.4.colon -text " : "
        entry .editcs.c.4.entry -textvariable ct(1)
        pack  .editcs.c.4.label -side left -anchor w
        pack  .editcs.c.4.entry \
              .editcs.c.4.colon \
                -side right

        frame .editcs.c.5
        global Fluid_force_coefficient_ca
        label .editcs.c.5.label -text $Fluid_force_coefficient_ca
        label .editcs.c.5.colon -text " : "
        entry .editcs.c.5.entry -textvariable ca(1)
        pack  .editcs.c.5.label -side left -anchor w
        pack  .editcs.c.5.entry \
              .editcs.c.5.colon \
                -side right

        frame .editcs.c.6
        global Fluid_force_coefficient_p
        label .editcs.c.6.label -text $Fluid_force_coefficient_p
        label .editcs.c.6.colon -text " : "
        entry .editcs.c.6.entry -textvariable pcn
        pack  .editcs.c.6.label -side left -anchor w
        pack  .editcs.c.6.entry \
              .editcs.c.6.colon \
                -side right

        global alloreach
        set alloreach all
        frame .editcs.c.r
        global Same_all Set_for_each_body_segment Set
	radiobutton .editcs.c.r.1 -variable alloreach -value all \
	              -text $Same_all -command EnableSetAll
	radiobutton .editcs.c.r.2 -variable alloreach -value each \
	              -text $Set_for_each_body_segment \
                      -command DisableSetAll
	button .editcs.c.r.3 -text $Set \
	              -command PopupSetCoefficients
	pack  .editcs.c.r.1 .editcs.c.r.2 -side left -padx 10
	pack  .editcs.c.r.3 -side left

        frame .editcs.6
        global Number_of_cycles
        label .editcs.6.label -text $Number_of_cycles
        label .editcs.6.colon -text " : "
        entry .editcs.6.entry -textvariable cycle_num
        pack  .editcs.6.label -side left -anchor w
        pack  .editcs.6.entry \
              .editcs.6.colon \
                -side right

        frame .editcs.7
        global Number_of_time_steps_for_one_cycle
        label .editcs.7.label -text $Number_of_time_steps_for_one_cycle
        label .editcs.7.colon -text " : "
        entry .editcs.7.entry -textvariable time_step
        pack  .editcs.7.label -side left -anchor w
        pack  .editcs.7.entry \
              .editcs.7.colon \
                -side right

        frame .editcs.8
        global Number_of_division_for_longitudinal_direction
        label .editcs.8.label -text $Number_of_division_for_longitudinal_direction
        label .editcs.8.colon -text " : "
        entry .editcs.8.entry -textvariable divl
        pack  .editcs.8.label -side left -anchor w
        pack  .editcs.8.entry \
              .editcs.8.colon \
                -side right

        frame .editcs.9
        global Number_of_division_for_radius_direction
        label .editcs.9.label -text $Number_of_division_for_radius_direction
        label .editcs.9.colon -text " : "
        entry .editcs.9.entry -textvariable divr
        pack  .editcs.9.label -side left -anchor w
        pack  .editcs.9.entry \
              .editcs.9.colon \
                -side right

        frame .editcs.10
        global Number_of_division_for_circumference_direction
        label .editcs.10.label -text $Number_of_division_for_circumference_direction
        label .editcs.10.colon -text " : "
        entry .editcs.10.entry -textvariable divt
        pack  .editcs.10.label -side left -anchor w
        pack  .editcs.10.entry \
              .editcs.10.colon \
                -side right

        # For AnyBody
        global anybody_brep_folder
        frame .editcs.a -relief groove -bd 2
        if {$anybody_brep_folder!=""} {
            frame .editcs.a.11
            frame .editcs.a.12
            frame .editcs.a.13

            # Body geometry
            global Body_geometry_musculo_skeletal_analysis \
                   AnyBody_original
            label .editcs.a.11.label \
                     -text $Body_geometry_musculo_skeletal_analysis
            radiobutton .editcs.a.11.r1 -text SWUM \
                             -variable anybody_body_geometry -value 1
            radiobutton .editcs.a.11.r2 -text $AnyBody_original \
                             -variable anybody_body_geometry -value 0
            pack  .editcs.a.11.label -side left -anchor w
            pack  .editcs.a.11.r2 \
                  .editcs.a.11.r1 \
                    -side right

            # Time step
            global Time_step_musculo_skeletal_analysis
            label .editcs.a.12.label \
                     -text $Time_step_musculo_skeletal_analysis
            label .editcs.a.12.colon -text " : "
            entry .editcs.a.12.entry -textvariable anybody_time_step
            pack  .editcs.a.12.label -side left -anchor w
            pack  .editcs.a.12.entry \
                  .editcs.a.12.colon \
                    -side right

            # Stroke
            global Stroke_musculo_skeletal_analysis \
                   Crawl Breast Back Butterfly
            label .editcs.a.13.label \
                     -text $Stroke_musculo_skeletal_analysis
            radiobutton .editcs.a.13.r1 -text $Crawl \
                             -variable anybody_stroke -value 1
            radiobutton .editcs.a.13.r2 -text $Breast \
                             -variable anybody_stroke -value 2
            radiobutton .editcs.a.13.r3 -text $Back \
                             -variable anybody_stroke -value 3
            radiobutton .editcs.a.13.r4 -text $Butterfly \
                             -variable anybody_stroke -value 4
            pack  .editcs.a.13.label -side left -anchor w
            pack  .editcs.a.13.r4 \
                  .editcs.a.13.r3 \
                  .editcs.a.13.r2 \
                  .editcs.a.13.r1 \
                    -side right
 
            pack .editcs.a.11 \
                 .editcs.a.12 \
                    -side top -fill x
        }

        pack .editcs.c.3 \
             .editcs.c.4 \
             .editcs.c.5 \
             .editcs.c.6 \
             .editcs.c.r \
                -side top -fill x

        pack \
             .editcs.d \
             .editcs.s \
             .editcs.0 \
             .editcs.b \
             .editcs.m \
             .editcs.1 \
             .editcs.2 \
             .editcs.c \
             .editcs.6 \
             .editcs.7 \
             .editcs.8 \
             .editcs.9 \
             .editcs.10 \
             .editcs.a \
                -side top -fill x

        # Save & Cancel
        frame .editcs.bottom
        global Save
        global Cancel
        button .editcs.bottom.ok     -text $Save \
             -command "SaveAnalysisSettings ; wm withdraw .editcs"
        button .editcs.bottom.cancel -text $Cancel \
             -command "wm withdraw .editcs"
        pack   .editcs.bottom.ok     \
               .editcs.bottom.cancel \
                 -side left -padx 5
        pack .editcs.bottom -side top -pady 5

        ChangeIcon .editcs

    } else {
        wm deiconify .editcs
    }
    # After making window, load values from data file.
    LoadAutoAnalysisSettings

    # Judge all or each for fluid force coefficients
    JudgeAllorEach
}


# Enable set all for fluid coefficients
proc EnableSetAll {} {
    .editcs.c.3.entry configure -state normal
    .editcs.c.4.entry configure -state normal
    .editcs.c.5.entry configure -state normal

    .editcs.c.r.3 configure -state disabled
}


# Disable set all for fluid coefficients
proc DisableSetAll {} {
    .editcs.c.3.entry configure -state disabled
    .editcs.c.4.entry configure -state disabled
    .editcs.c.5.entry configure -state disabled

    .editcs.c.r.3 configure -state normal
}


# Judge whether fluid coefficients are set for all or each
proc JudgeAllorEach {} {
    global cn ct ca alloreach

    # first, set as "all"
    set alloreach all

    # check coefficients are different or not
    for {set i 2} {$i<=21} {incr i} {
        if {"$cn($i)"!="$cn(1)"} {set alloreach each}
        if {"$ct($i)"!="$ct(1)"} {set alloreach each}
        if {"$ca($i)"!="$ca(1)"} {set alloreach each}
    }
    if {$alloreach=="all"} {
        catch { EnableSetAll }
    } else {
        catch { DisableSetAll }
    }
}


# Set fluid force coefficients for each body part
proc PopupSetCoefficients {} {
    # make window (if does not exist)
    if { [winfo exists .editcs.sc]==0 } {
        toplevel .editcs.sc
        wm title .editcs.sc "Swumsuit: Set Fluid Force Coefficients"

        frame .editcs.sc.f
        frame .editcs.sc.p

        # panel part
        global OK Cancel
        button .editcs.sc.p.ok -text "  $OK  "   \
                       -command SetCoefficientsOK
        button .editcs.sc.p.cancel -text $Cancel \
                       -command "JudgeAllorEach ; wm withdraw .editcs.sc"
        pack .editcs.sc.p.ok .editcs.sc.p.cancel \
                   -side left -padx 20 -pady 10 -expand 1

        # table part
        label .editcs.sc.f.la01 -text Cn
        label .editcs.sc.f.la02 -text Ct
        label .editcs.sc.f.la03 -text Ca
        grid  .editcs.sc.f.la01 -row 0 -column 1
        grid  .editcs.sc.f.la02 -row 0 -column 2
        grid  .editcs.sc.f.la03 -row 0 -column 3

        global segm_name cn_tmp ct_tmp ca_tmp
        for {set i 1} {$i<=21} {incr i} {
            label .editcs.sc.f.la$i -text $segm_name($i)
            entry .editcs.sc.f.cn$i -textvariable cn_tmp($i)
            entry .editcs.sc.f.ct$i -textvariable ct_tmp($i)
            entry .editcs.sc.f.ca$i -textvariable ca_tmp($i)
            grid  .editcs.sc.f.la$i -row $i -column 0 -sticky w
            grid  .editcs.sc.f.cn$i -row $i -column 1 -sticky w
            grid  .editcs.sc.f.ct$i -row $i -column 2 -sticky w
            grid  .editcs.sc.f.ca$i -row $i -column 3 -sticky w
        }

        pack .editcs.sc.f .editcs.sc.p -side top

        ChangeIcon .editcs.sc
    } else {
        wm deiconify .editcs.sc
    }
    LoadCoefficients
}


# Load fluid force coefficients
proc LoadCoefficients {} {
    global cn ct ca cn_tmp ct_tmp ca_tmp
    
    for {set i 1} {$i<=21} {incr i} {
        set cn_tmp($i) $cn($i)
        set ct_tmp($i) $ct($i)
        set ca_tmp($i) $ca($i)
    }
}


# Set fluid force coefficients OK
proc SetCoefficientsOK {} {
    global cn ct ca cn_tmp ct_tmp ca_tmp
    
    for {set i 1} {$i<=21} {incr i} {
        set cn($i) $cn_tmp($i)
        set ct($i) $ct_tmp($i)
        set ca($i) $ca_tmp($i)
    }
    JudgeAllorEach
    wm withdraw .editcs.sc
}


# Initial condition window
proc EditInitialCondition {} {
    # make window (if does not exist)
    if { [winfo exists .editic ]==0 } {
        toplevel .editic
        wm title .editic "Swumsuit: Edit Initial Condition"

        frame .editic.1
        global Initial_position
        label .editic.1.label -text $Initial_position
        label .editic.1.xcolon -text "  x :"
        label .editic.1.ycolon -text "  y :"
        label .editic.1.zcolon -text "  z :"
        entry .editic.1.xentry -textvariable inipos_x
        entry .editic.1.yentry -textvariable inipos_y
        entry .editic.1.zentry -textvariable inipos_z
        pack  .editic.1.label -side left -anchor w
        pack  .editic.1.zentry \
              .editic.1.zcolon \
              .editic.1.yentry \
              .editic.1.ycolon \
              .editic.1.xentry \
              .editic.1.xcolon \
                -side right

        frame .editic.2
        global Initial_directions_of_principal_axes
        label .editic.2.label -text $Initial_directions_of_principal_axes
        label .editic.2.num -text "1"
        label .editic.2.xcolon -text "  x :"
        label .editic.2.ycolon -text "  y :"
        label .editic.2.zcolon -text "  z :"
        entry .editic.2.xentry -textvariable inidirec_1_x
        entry .editic.2.yentry -textvariable inidirec_1_y
        entry .editic.2.zentry -textvariable inidirec_1_z
        pack  .editic.2.label -side left -anchor w
        pack  .editic.2.zentry \
              .editic.2.zcolon \
              .editic.2.yentry \
              .editic.2.ycolon \
              .editic.2.xentry \
              .editic.2.xcolon \
              .editic.2.num \
                -side right

        frame .editic.3
        label .editic.3.num -text "2"
        label .editic.3.xcolon -text "  x :"
        label .editic.3.ycolon -text "  y :"
        label .editic.3.zcolon -text "  z :"
        entry .editic.3.xentry -textvariable inidirec_2_x
        entry .editic.3.yentry -textvariable inidirec_2_y
        entry .editic.3.zentry -textvariable inidirec_2_z
        #pack  .editic.3.label -side left -anchor w
        pack  .editic.3.zentry \
              .editic.3.zcolon \
              .editic.3.yentry \
              .editic.3.ycolon \
              .editic.3.xentry \
              .editic.3.xcolon \
              .editic.3.num \
                -side right

        frame .editic.4
        label .editic.4.num -text "3"
        label .editic.4.xcolon -text "  x :"
        label .editic.4.ycolon -text "  y :"
        label .editic.4.zcolon -text "  z :"
        entry .editic.4.xentry -textvariable inidirec_3_x
        entry .editic.4.yentry -textvariable inidirec_3_y
        entry .editic.4.zentry -textvariable inidirec_3_z
        #pack  .editic.4.label -side left -anchor w
        pack  .editic.4.zentry \
              .editic.4.zcolon \
              .editic.4.yentry \
              .editic.4.ycolon \
              .editic.4.xentry \
              .editic.4.xcolon \
              .editic.4.num \
                -side right

        frame .editic.5
        global Initial_velocity
        label .editic.5.label -text $Initial_velocity
        label .editic.5.xcolon -text "  x :"
        label .editic.5.ycolon -text "  y :"
        label .editic.5.zcolon -text "  z :"
        entry .editic.5.xentry -textvariable inivel_x
        entry .editic.5.yentry -textvariable inivel_y
        entry .editic.5.zentry -textvariable inivel_z
        pack  .editic.5.label -side left -anchor w
        pack  .editic.5.zentry \
              .editic.5.zcolon \
              .editic.5.yentry \
              .editic.5.ycolon \
              .editic.5.xentry \
              .editic.5.xcolon \
                -side right

        frame .editic.6
        global Initial_angular_velocity
        label .editic.6.label -text $Initial_angular_velocity
        label .editic.6.xcolon -text "  1 :"
        label .editic.6.ycolon -text "  2 :"
        label .editic.6.zcolon -text "  3 :"
        entry .editic.6.xentry -textvariable iniavel_x
        entry .editic.6.yentry -textvariable iniavel_y
        entry .editic.6.zentry -textvariable iniavel_z
        pack  .editic.6.label -side left -anchor w
        pack  .editic.6.zentry \
              .editic.6.zcolon \
              .editic.6.yentry \
              .editic.6.ycolon \
              .editic.6.xentry \
              .editic.6.xcolon \
                -side right

        frame .editic.7
        global Initial_direction_specified_by_degree
        label .editic.7.label -text $Initial_direction_specified_by_degree
        label .editic.7.colon -text "  : "
        entry .editic.7.entry -textvariable direcd
        pack  .editic.7.label -side left -anchor w
        pack  .editic.7.colon \
              .editic.7.entry \
                -side left 

        # seperaters
        frame .editic.s1 -height 2 -relief sunken -bd 1
        frame .editic.s2 -height 2 -relief sunken -bd 1
        frame .editic.s3 -height 2 -relief sunken -bd 1
        frame .editic.s4 -height 2 -relief sunken -bd 1
        frame .editic.s5 -height 2 -relief sunken -bd 1

        pack .editic.1 \
             .editic.s1 \
             .editic.2 \
             .editic.3 \
             .editic.4 \
             .editic.s2 \
             .editic.5 \
             .editic.s3 \
             .editic.6 \
             .editic.s4 \
             .editic.7 \
             .editic.s5 \
                -side top -fill x

        # Save & Cancel
        frame .editic.bottom
        global Save
        global Cancel
        button .editic.bottom.ok     -text $Save \
             -command "SaveAnalysisSettings ; wm withdraw .editic"
        button .editic.bottom.cancel -text $Cancel \
             -command "wm withdraw .editic"
        pack   .editic.bottom.ok     \
               .editic.bottom.cancel \
                 -side left -padx 5
        pack .editic.bottom -side top -pady 5

        ChangeIcon .editic

    } else {
        wm deiconify .editic
    }

    # After making window, load values from data file.
    LoadAutoAnalysisSettings
}

# Output setting window
proc EditOutputSettings {} {
    # make window (if does not exist)
    if { [winfo exists .editos ]==0 } {
        toplevel .editos
        wm title .editos "Swumsuit: Edit Output Settings"

        global Rigid_Body_Motion Force_Moment_Power Joint_Torque \
               Animation All_cycles Last_cycle None

        # rigid body motion
        frame .editos.r -bd 2 -relief groove
        label .editos.r.t -text $Rigid_Body_Motion -anchor w
        radiobutton .editos.r.a -text $All_cycles \
                          -variable flagoutr -value 2
        radiobutton .editos.r.l -text $Last_cycle \
                          -variable flagoutr -value 1
        radiobutton .editos.r.n -text $None \
                          -variable flagoutr -value 0
        pack .editos.r.t -side left
        pack .editos.r.n \
             .editos.r.l \
             .editos.r.a -side right

        # force, moment and power
        frame .editos.f -bd 2 -relief groove
        label .editos.f.t -text $Force_Moment_Power -anchor w
        radiobutton .editos.f.a -text $All_cycles \
                          -variable flagoutf -value 2
        radiobutton .editos.f.l -text $Last_cycle \
                          -variable flagoutf -value 1
        radiobutton .editos.f.n -text $None \
                          -variable flagoutf -value 0
        pack .editos.f.t -side left
        pack .editos.f.n \
             .editos.f.l \
             .editos.f.a -side right

        # joint torque
        frame .editos.j -bd 2 -relief groove
        label .editos.j.t -text $Joint_Torque -anchor w
        radiobutton .editos.j.a -text $All_cycles \
                          -variable flagoutj -value 2
        radiobutton .editos.j.l -text $Last_cycle \
                          -variable flagoutj -value 1
        radiobutton .editos.j.n -text $None \
                          -variable flagoutj -value 0
        pack .editos.j.t -side left
        pack .editos.j.n \
             .editos.j.l \
             .editos.j.a -side right

        # animation
        frame .editos.a -bd 2 -relief groove
        label .editos.a.t -text $Animation -anchor w
        radiobutton .editos.a.a -text $All_cycles \
                          -variable flagouta -value 2
        radiobutton .editos.a.l -text $Last_cycle \
                          -variable flagouta -value 1
        radiobutton .editos.a.n -text $None \
                          -variable flagouta -value 0
        pack .editos.a.t -side left
        pack .editos.a.n \
             .editos.a.l \
             .editos.a.a -side right

        # AnyBody
        global Files_musculo_skeletal_analysis
        frame .editos.m -bd 2 -relief groove
        label .editos.m.t -text $Files_musculo_skeletal_analysis \
                                                         -anchor w
        radiobutton .editos.m.a -text $All_cycles \
                          -variable flagoutm -value 2 -state disabled
        radiobutton .editos.m.l -text $Last_cycle \
                          -variable flagoutm -value 1
        radiobutton .editos.m.n -text $None \
                          -variable flagoutm -value 0
        pack .editos.m.t -side left
        pack .editos.m.n \
             .editos.m.l \
             .editos.m.a -side right


        # panel
        frame .editos.p
        global Save Cancel
        button .editos.p.ok     -text $Save \
             -command "SaveAnalysisSettings ; wm withdraw .editos"
        button .editos.p.cancel -text $Cancel \
             -command "wm withdraw .editos"
        pack   .editos.p.ok     \
               .editos.p.cancel \
                 -side left -padx 5

        pack .editos.r \
             .editos.f \
             .editos.j \
             .editos.a \
             .editos.m \
             -side top -anchor w -fill x
        pack .editos.p -side top -pady 5

        ChangeIcon .editos

    } else {
        wm deiconify .editos
    }
    # After making window, load values from data file.
    LoadAutoAnalysisSettings
}


# Penetration judging setting window
proc EditPeneJudgeSettings {} {
    global flagpene
    # make window (if does not exist)
    if { [winfo exists .editjs ]==0 } {
        toplevel .editjs
        wm title .editjs "Swumsuit: Edit Penetration Judging Settings"

        global Label_pene Yes No Save Cancel

        for {set i 0} {$i<=10} {incr i} {
            if {$i==0} {
                frame .editjs.f$i -bd 2 -relief groove
            } else {
                frame .editjs.f$i -bd 2 -relief flat
            }
            label .editjs.f$i.t -text $Label_pene($i) -anchor w

            if {$i==0} {
                radiobutton .editjs.f$i.r1 -text $Yes \
                  -variable flagpene($i) -value 1 -command AblePene
                radiobutton .editjs.f$i.r2 -text $No \
                  -variable flagpene($i) -value 0 -command DisablePene
            } else {
                radiobutton .editjs.f$i.r1 -text $Yes \
                                  -variable flagpene($i) -value 1
                radiobutton .editjs.f$i.r2 -text $No \
                                  -variable flagpene($i) -value 0
            }
            pack .editjs.f$i.t -side left
            pack .editjs.f$i.r2 .editjs.f$i.r1 -side right
        }



        # panel
        frame .editjs.p -bd 2 -relief groove
        global Save Cancel
        button .editjs.p.ok     -text $Save \
             -command "SaveAnalysisSettings ; wm withdraw .editjs"
        button .editjs.p.cancel -text $Cancel \
             -command "wm withdraw .editjs"
        pack   .editjs.p.ok     \
               .editjs.p.cancel \
                 -side left -padx 5 -pady 5 -expand 1

        # packing
        for {set i 0} {$i<=10} {incr i} {
            pack .editjs.f$i -side top -anchor w -fill x
        }
        pack .editjs.p -side top -pady 0 -fill x -expand 1
 
        ChangeIcon .editjs

    } else {
        wm deiconify .editjs
    }
    # After making window, load values from data file.
    LoadAutoAnalysisSettings

    # if flagpene(0) is 0, disable other flag lines
    if {$flagpene(0)==0} {
        for {set i 1} {$i<=10} {incr i} {
            .editjs.f$i.t  configure -state disabled
            .editjs.f$i.r1 configure -state disabled
            .editjs.f$i.r2 configure -state disabled
        }
    }
}





proc AblePene {} {
    for {set i 1} {$i<=10} {incr i} {
        .editjs.f$i.t  configure -state normal
        .editjs.f$i.r1 configure -state normal
        .editjs.f$i.r2 configure -state normal
    }
}


proc DisablePene {} {
    for {set i 1} {$i<=10} {incr i} {
        .editjs.f$i.t  configure -state disabled
        .editjs.f$i.r1 configure -state disabled
        .editjs.f$i.r2 configure -state disabled
    }
}



# Optimization setting window
proc EditOptSettings {} {
    # make window (if does not exist)
    if { [winfo exists .editps ]==0 } {
        toplevel .editps
        wm title .editps "Swumsuit: Edit Optimization Settings"

        global Perform_optimization Yes No \
               Display_window \
               Number_of_design_parameters \
               Initial_values_of_design_parameters Edit \
               Initial_size_of_simplex \
               Limit_of_iteration_number \
               Tolerance_of_convergence \
               Script_to_set_design_parameters \
               Script_to_set_objective_function \
               Number_of_whole_loop

        # opt_flag
        frame .editps.f -bd 2 -relief groove
        label .editps.f.t -text $Perform_optimization -anchor w
        radiobutton .editps.f.r1 -text $Yes \
                          -variable opt_flag -value 1
        radiobutton .editps.f.r2 -text $No \
                          -variable opt_flag -value 0
        pack .editps.f.t -side left
        pack .editps.f.r2 .editps.f.r1 -side right

        # silent_flag
        frame .editps.f2 -bd 2 -relief groove
        label .editps.f2.t -text $Display_window -anchor w
        radiobutton .editps.f2.r1 -text $Yes \
                          -variable silent_flag -value 0
        radiobutton .editps.f2.r2 -text $No \
                          -variable silent_flag -value 1
        pack .editps.f2.t -side left
        pack .editps.f2.r2 .editps.f2.r1 -side right

        # dimension
        frame .editps.n -bd 2 -relief groove
        label .editps.n.t -text $Number_of_design_parameters -anchor w
        label .editps.n.c -text "  : "
        entry .editps.n.e -textvariable num_dp 
        pack  .editps.n.t -side left -anchor w
        pack  .editps.n.e .editps.n.c -side right

        # size of simplex
        frame .editps.s -bd 2 -relief groove
        label .editps.s.t -text $Initial_size_of_simplex -anchor w
        label .editps.s.c -text "  : "
        entry .editps.s.e -textvariable size_simplex 
        pack  .editps.s.t -side left -anchor w
        pack  .editps.s.e .editps.s.c -side right

        # limit of iteration number
        frame .editps.l -bd 2 -relief groove
        label .editps.l.t -text $Limit_of_iteration_number -anchor w
        label .editps.l.c -text "  : "
        entry .editps.l.e -textvariable itmax
        pack  .editps.l.t -side left -anchor w
        pack  .editps.l.e .editps.l.c -side right

        # tolerance of convergence
        frame .editps.t -bd 2 -relief groove
        label .editps.t.t -text $Tolerance_of_convergence -anchor w
        label .editps.t.c -text "  : "
        entry .editps.t.e -textvariable ftol
        pack  .editps.t.t -side left -anchor w
        pack  .editps.t.e .editps.t.c -side right

        # number of whole iteration loop
        frame .editps.w -bd 2 -relief groove
        label .editps.w.t -text $Number_of_whole_loop -anchor w
        label .editps.w.c -text "  : "
        entry .editps.w.e -textvariable opt_lastloop
        pack  .editps.w.t -side left -anchor w
        pack  .editps.w.e .editps.w.c -side right

        # panel
        frame .editps.p
        global Save Cancel
        button .editps.p.ok     -text $Save \
             -command "SaveAnalysisSettings ; wm withdraw .editps"
        button .editps.p.cancel -text $Cancel \
             -command "wm withdraw .editps"
        pack   .editps.p.ok     \
               .editps.p.cancel \
                 -side left -padx 5

        # packing
        pack .editps.f \
             .editps.f2 \
             .editps.n \
             .editps.s \
             .editps.l \
             .editps.t \
             .editps.w \
                       -side top -anchor w -fill x
        pack .editps.p -side top -pady 5
 
        ChangeIcon .editps

    } else {
        wm deiconify .editps
    }
    # After making window, load values from data file.
    LoadAutoAnalysisSettings
}



# Load values from data file
proc LoadAutoAnalysisSettings {} {
    if {[file exists analysis_settings.dat]==1} {
        # first, initialize comsolv etc.
        global comsolv vgxsolv vgysolv vgzsolv \
               ome1solv ome2solv ome3solv
        set comsolv ""
        set vgxsolv ""
        set vgysolv ""
        set vgzsolv ""
        set ome1solv ""
        set ome2solv ""
        set ome3solv ""

        global anybody_body_geometry anybody_time_step anybody_stroke
        global flagoutm
        set anybody_body_geometry ""
        set anybody_time_step ""
        set anybody_stroke ""
        set flagoutm "0"

        global numb
        set numb ""

        global conam
        set conam ""

        global multi
        set multi ""

        global pcn
        set pcn ""

        set f [open analysis_settings.dat r]    
        while {[gets $f line]>=0} {
            set line [string trim $line]
            if {$line=="cycle="} {
                gets $f line
                global cycle
                set cycle [string trim $line]
            } elseif { $line=="drag_gli="} {
                gets $f line
                global drag_gli
                set drag_gli [string trim $line]
            } elseif { $line=="numb="} {
                gets $f line
                set numb [string trim $line]
            } elseif { $line=="conam="} {
                gets $f line
                set conam [string trim $line]
            } elseif { $line=="multi="} {
                gets $f line
                set multi [string trim $line]
            } elseif { $line=="num_subprojects="} {
                gets $f line
                global num_subprojects
                set num_subprojects [string trim $line]
            } elseif { $line=="cn="} {
                gets $f line
                global cn
                set cn(1) [string trim $line]
                for {set i 2} {$i<=21} {incr i} {
                    set cn($i) $cn(1)
                }
            } elseif { $line=="ct="} {
                gets $f line
                global ct
                set ct(1) [string trim $line]
                for {set i 2} {$i<=21} {incr i} {
                    set ct($i) $ct(1)
                }
            } elseif { $line=="ca="} {
                gets $f line
                global ca
                set ca(1) [string trim $line]
                for {set i 2} {$i<=21} {incr i} {
                    set ca($i) $ca(1)
                }
            } elseif { $line=="time_step="} {
                gets $f line
                global time_step
                set time_step [string trim $line]
            } elseif { $line=="cycle_num="} {
                gets $f line
                global cycle_num
                set cycle_num [string trim $line]
            } elseif { $line=="divl="} {
                gets $f line
                global divl
                set divl [string trim $line]
            } elseif { $line=="divr="} {
                gets $f line
                global divr
                set divr [string trim $line]
            } elseif { $line=="divt="} {
                gets $f line
                global divt
                set divt [string trim $line]
            } elseif { $line=="inipos="} {
                gets $f line
                global inipos_x inipos_y inipos_z
                set inipos_x [string trim [lindex $line 0]]
                set inipos_y [string trim [lindex $line 1]]
                set inipos_z [string trim [lindex $line 2]]
            } elseif { $line=="inidirec="} {
                gets $f line
                global inidirec_1_x inidirec_1_y inidirec_1_z
                set inidirec_1_x [string trim [lindex $line 0]]
                set inidirec_1_y [string trim [lindex $line 1]]
                set inidirec_1_z [string trim [lindex $line 2]]
                gets $f line
                global inidirec_2_x inidirec_2_y inidirec_2_z
                set inidirec_2_x [string trim [lindex $line 0]]
                set inidirec_2_y [string trim [lindex $line 1]]
                set inidirec_2_z [string trim [lindex $line 2]]
                gets $f line
                global inidirec_3_x inidirec_3_y inidirec_3_z
                set inidirec_3_x [string trim [lindex $line 0]]
                set inidirec_3_y [string trim [lindex $line 1]]
                set inidirec_3_z [string trim [lindex $line 2]]
            } elseif { $line=="inivel="} {
                gets $f line
                global inivel_x inivel_y inivel_z
                set inivel_x [string trim [lindex $line 0]]
                set inivel_y [string trim [lindex $line 1]]
                set inivel_z [string trim [lindex $line 2]]
            } elseif { $line=="iniavel="} {
                gets $f line
                global iniavel_x iniavel_y iniavel_z
                set iniavel_x [string trim [lindex $line 0]]
                set iniavel_y [string trim [lindex $line 1]]
                set iniavel_z [string trim [lindex $line 2]]
            } elseif { $line=="direcd="} {
                gets $f line
                global direcd
                set direcd [string trim $line]
            } elseif { $line=="flagoutr="} {
                gets $f line
                global flagoutr
                set flagoutr [string trim $line]
            } elseif { $line=="flagoutf="} {
                gets $f line
                global flagoutf
                set flagoutf [string trim $line]
            } elseif { $line=="flagoutj="} {
                gets $f line
                global flagoutj
                set flagoutj [string trim $line]
            } elseif { $line=="flagouta="} {
                gets $f line
                global flagouta
                set flagouta [string trim $line]
            } elseif { $line=="cn_list="} {
                global cn
		for {set i 1} {$i<=21} {incr i} {
                    gets $f line
                    set cn($i) [string trim $line]
		}
            } elseif { $line=="ct_list="} {
                global ct
		for {set i 1} {$i<=21} {incr i} {
                    gets $f line
                    set ct($i) [string trim $line]
		}
            } elseif { $line=="ca_list="} {
                global ca
		for {set i 1} {$i<=21} {incr i} {
                    gets $f line
                    set ca($i) [string trim $line]
		}
            } elseif { $line=="motsolv="} {
                gets $f line
                set comsolv [string trim $line]
                gets $f line
                set vgxsolv [string trim $line]
                gets $f line
                set vgysolv [string trim $line]
                gets $f line
                set vgzsolv [string trim $line]
                gets $f line
                set ome1solv [string trim $line]
                gets $f line
                set ome2solv [string trim $line]
                gets $f line
                set ome3solv [string trim $line]
            } elseif { $line=="opt_flag="} {
                gets $f line
                global opt_flag
                set opt_flag [string trim $line]
            } elseif { $line=="silent_flag="} {
                gets $f line
                global silent_flag
                set silent_flag [string trim $line]
            } elseif { $line=="num_dp="} {
                gets $f line
                global num_dp
                set num_dp [string trim $line]
            } elseif { $line=="size_simplex="} {
                gets $f line
                global size_simplex
                set size_simplex [string trim $line]
            } elseif { $line=="itmax="} {
                gets $f line
                global itmax
                set itmax [string trim $line]
            } elseif { $line=="ftol="} {
                gets $f line
                global ftol
                set ftol [string trim $line]
            } elseif { $line=="flagpene="} {
                global flagpene
		for {set i 0} {$i<=10} {incr i} {
                    gets $f line
                    set flagpene($i) [string trim $line]
		}
            } elseif { $line=="opt_lastloop="} {
                gets $f line
                global opt_lastloop
                set opt_lastloop  [string trim $line]
            } elseif { $line=="flagoutm="} {
                gets $f line
                set flagoutm  [string trim $line]
            } elseif { $line=="anybody_body_geometry="} {
                gets $f line
                set anybody_body_geometry  [string trim $line]
            } elseif { $line=="anybody_time_step="} {
                gets $f line
                set anybody_time_step  [string trim $line]
            } elseif { $line=="anybody_stroke="} {
                gets $f line
                set anybody_stroke  [string trim $line]
            } elseif { $line=="pcn="} {
                gets $f line
                set pcn  [string trim $line]
            } else {
            }
        }
        close $f

        # if comsolv etc. are not found. i.e., old data format case
        global comsolv vgxsolv vgysolv vgzsolv \
               ome1solv ome2solv ome3solv
        if {"$comsolv"==""} {
            set comsolv 1
            set vgxsolv 1
            set vgysolv 1
            set vgzsolv 1
            set ome1solv 1
            set ome2solv 1
            set ome3solv 1
        }

        # if AnyBody settings are not found, set default values
        if {$anybody_body_geometry==""} {
            set anybody_body_geometry "1"
        }
        if {$anybody_time_step==""} {
            set anybody_time_step $time_step
        }
        if {$anybody_stroke==""} {
            set anybody_stroke "1"
        }

        # if numb settings is not found, set default value (21)
        if {$numb==""} {
            set numb "21"
        }

        # if conam settings is not found, set default value (0)
        if {$conam==""} {
            set conam "0"
        }

        # if multi settings is not found, set default value (0)
        if {$multi==""} {
            set multi "0"
        }

        # if pcn is not found, set default value (1.0)
        if {$pcn==""} {
            set pcn "1.0"
        }
    } else {
        global No_analysis_settings_file
        tk_messageBox -type ok -message $No_analysis_settings_file \
                      -icon warning
    }
}
 
# Save analysis settings
proc SaveAnalysisSettings {} {
    global numb
    global conam
    global multi
    global num_subprojects
    global cycle
    global drag_gli
    global cn ct ca
    global time_step
    global cycle_num
    global divl divr divt
    global inipos_x inipos_y inipos_z
    global inidirec_1_x inidirec_1_y inidirec_1_z
    global inidirec_2_x inidirec_2_y inidirec_2_z
    global inidirec_3_x inidirec_3_y inidirec_3_z
    global inivel_x inivel_y inivel_z
    global iniavel_x iniavel_y iniavel_z
    global direcd
    global flagoutr flagoutf flagoutj flagouta flagoutm
    global comsolv vgxsolv vgysolv vgzsolv ome1solv ome2solv ome3solv
    global opt_flag silent_flag num_dp size_simplex itmax ftol
    global flagpene opt_lastloop
    global anybody_body_geometry anybody_time_step anybody_stroke
    global alloreach
    global pcn

    # check if all parameters are set.
    # if not, set it as "Not_set"

    # write parameters
    set f [open analysis_settings.dat w]
    fconfigure $f -translation lf
    puts $f "multi="
    puts $f " $multi\n"
    puts $f "num_subprojects="
    puts $f " $num_subprojects\n"
    puts $f "numb="
    puts $f " $numb\n"
    puts $f "conam="
    puts $f " $conam\n"
    puts $f "cycle="
    puts $f " $cycle\n"
    puts $f "drag_gli="
    puts $f " $drag_gli\n"

    puts $f "cn_list="
    for {set i 1} {$i<=21} {incr i} {
        if {$alloreach=="all"} {
            puts $f " $cn(1)"
        } else {
            puts $f " $cn($i)"
        }
    }
    puts $f ""

    puts $f "ct_list="
    for {set i 1} {$i<=21} {incr i} {
        if {$alloreach=="all"} {
            puts $f " $ct(1)"
        } else {
            puts $f " $ct($i)"
        }
    }
    puts $f ""

    puts $f "ca_list="
        for {set i 1} {$i<=21} {incr i} {
        if {$alloreach=="all"} {
            puts $f " $ca(1)"
        } else {
            puts $f " $ca($i)"
        }
    }
    puts $f ""

    JudgeAllorEach
    
    puts $f "time_step="
    puts $f " $time_step\n"
    puts $f "cycle_num="
    puts $f " $cycle_num\n"
    puts $f "divl="
    puts $f " $divl\n"
    puts $f "divr="
    puts $f " $divr\n"
    puts $f "divt="
    puts $f " $divt\n"
    puts $f "inipos="
    puts $f " $inipos_x  $inipos_y  $inipos_z\n"
    puts $f "inidirec="
    puts $f " $inidirec_1_x  $inidirec_1_y  $inidirec_1_z"
    puts $f " $inidirec_2_x  $inidirec_2_y  $inidirec_2_z"
    puts $f " $inidirec_3_x  $inidirec_3_y  $inidirec_3_z\n"
    puts $f "inivel="
    puts $f " $inivel_x  $inivel_y  $inivel_z\n"
    puts $f "iniavel="
    puts $f " $iniavel_x  $iniavel_y  $iniavel_z\n"
    puts $f "direcd="
    puts $f " $direcd\n"
    puts $f "flagoutr="
    puts $f " $flagoutr\n"
    puts $f "flagoutf="
    puts $f " $flagoutf\n"
    puts $f "flagoutj="
    puts $f " $flagoutj\n"
    puts $f "flagouta="
    puts $f " $flagouta\n"
    puts $f "motsolv="
    puts $f " $comsolv"
    puts $f " $vgxsolv"
    puts $f " $vgysolv"
    puts $f " $vgzsolv"
    puts $f " $ome1solv"
    puts $f " $ome2solv"
    puts $f " $ome3solv\n"

    puts $f "opt_flag="
    puts $f " $opt_flag\n"
    puts $f "silent_flag="
    puts $f " $silent_flag\n"
    puts $f "num_dp="
    puts $f " $num_dp\n"
    puts $f "size_simplex="
    puts $f " $size_simplex\n"
    puts $f "itmax="
    puts $f " $itmax\n"
    puts $f "ftol="
    puts $f " $ftol\n"

    puts $f "flagpene="
        for {set i 0} {$i<=10} {incr i} {
            puts $f " $flagpene($i)"
    }
    puts $f ""

    puts $f "opt_lastloop="
    puts $f " $opt_lastloop\n"

    # global anybody_brep_folder
    # if {$anybody_brep_folder!=""} {
        puts $f "flagoutm="
        puts $f " $flagoutm\n"
        puts $f "anybody_body_geometry="
        puts $f " $anybody_body_geometry\n"
        puts $f "anybody_time_step="
        puts $f " $anybody_time_step\n"
        puts $f "anybody_stroke="
        puts $f " $anybody_stroke\n"
    # }

    puts $f "pcn="
    puts $f " $pcn\n"

    close $f
}


# Edit sciript for optimization
proc EditOptScript { file } {
    if {$file=="opt_initial_values.tcl"} {
        set n 1
    } elseif {$file=="opt_design_parameters.tcl"} {
        set n 2
    } elseif {$file=="opt_objective_function.tcl"} {
        set n 3
    } else {
        return
    }

    # first, make window 
    if {[winfo exists .eo$n ]==0} {
        toplevel .eo$n
	wm title .eo$n "Swumsuit: Edit $file"

        frame .eo$n.t 
        text .eo$n.t.t -width 80 -height 24 \
            -yscrollcommand ".eo$n.t.s set"
        scrollbar .eo$n.t.s -orient vertical -command ".eo$n.t.t yview"
        grid .eo$n.t.t -row 0 -column 0 -sticky nsew
        grid .eo$n.t.s -row 0 -column 1 -sticky ns

        frame .eo$n.p
        global Save Cancel
        button .eo$n.p.save   -text $Save \
                              -command "SaveOptScript $n $file"
        button .eo$n.p.cancel -text $Cancel \
                              -command "wm withdraw .eo$n"
        pack   .eo$n.p.save .eo$n.p.cancel -side left -expand 1

        pack .eo$n.t -side top -pady 5
        pack .eo$n.p -side top -pady 10 -fill x

        ChangeIcon .eo$n

    } else {
        wm deiconify .eo$n
    }

    # load file
    if {[file exists $file]=="1"} {
        set f [open $file r]
        .eo$n.t.t delete 1.0 end
        .eo$n.t.t insert 1.0 [read $f]
        close $f
    } else {
    # if file does not exists, load sample
        global sourcedir
        set f [open $sourcedir/sample_$file r]
        .eo$n.t.t delete 1.0 end
        .eo$n.t.t insert 1.0 [read $f]
        close $f
    }
}


# Save script for optimization
proc SaveOptScript { n file } {
    set f [open $file w]
    puts $f [.eo$n.t.t get 1.0 end] 
    close $f
    wm withdraw .eo$n
}
