########################################################################
#                                                                      #
#     Body Geometry Editor for Swumsuit                                #
#                                            since 2005.1.11           #
#                                            (c) Motomu Nakashima      #
########################################################################


proc EditBodyGeometry {} {
    # make window (if does not exist)
    if { [winfo exists .ebm]==0 } {
        toplevel .ebm
        wm title .ebm "Swumsuit: Edit Body Geometry"

        frame .ebm.tab -relief groove -bd 2
        frame .ebm.panel 

        global Root_width Root_depth Tip_width Tip_depth Length Density
        label .ebm.tab.l1 -text $Root_depth
        label .ebm.tab.l2 -text $Root_width
        label .ebm.tab.l3 -text $Tip_depth
        label .ebm.tab.l4 -text $Tip_width
        label .ebm.tab.l5 -text $Length
        label .ebm.tab.l6 -text $Density

        EbmOpenEntries

        global Figure Apply Save Cancel
        button .ebm.panel.anim   -text $Figure -command ShowBodyGeometry
        button .ebm.panel.apply  -text $Apply -command ApplyBodyGeometry
        button .ebm.panel.save   -text $Save -command SaveBodyGeometry
        button .ebm.panel.cancel -text $Cancel -command exit
        pack   .ebm.panel.anim \
               .ebm.panel.apply \
               .ebm.panel.save \
               .ebm.panel.cancel \
                 -side left -padx 20 -pady 10 -expand 1

        grid  .ebm.tab.l1 -row 0 -column 1
        grid  .ebm.tab.l2 -row 0 -column 2
        grid  .ebm.tab.l3 -row 0 -column 3
        grid  .ebm.tab.l4 -row 0 -column 4
        grid  .ebm.tab.l5 -row 0 -column 5
        grid  .ebm.tab.l6 -row 0 -column 6

        global Text_bu1 Text_bu2 Text_bu3 Text_bu4 Text_bu5 Text_bu6 \
               Text_bu7 Text_bu8 Text_bu9
        label .ebm.tab.lbu1 -text $Text_bu1
        label .ebm.tab.lbu2 -text $Text_bu2
        label .ebm.tab.lbu3 -text $Text_bu3
        label .ebm.tab.lbu4 -text $Text_bu4
        label .ebm.tab.lbu5 -text $Text_bu5
        label .ebm.tab.lbu6 -text $Text_bu6
        label .ebm.tab.lbu7 -text $Text_bu7
        label .ebm.tab.lbu8 -text $Text_bu8
        label .ebm.tab.lbu9 -text $Text_bu9

        entry .ebm.tab.ebu1 -width 14 -textvariable bg_bu(1)
        entry .ebm.tab.ebu2 -width 14 -textvariable bg_bu(2)
        entry .ebm.tab.ebu3 -width 14 -textvariable bg_bu(3)
        entry .ebm.tab.ebu4 -width 14 -textvariable bg_bu(4)
        entry .ebm.tab.ebu5 -width 14 -textvariable bg_bu(5)
        entry .ebm.tab.ebu6 -width 14 -textvariable bg_bu(6)
        entry .ebm.tab.ebu7 -width 14 -textvariable bg_bu(7)
        entry .ebm.tab.ebu8 -width 10 -textvariable bg_bu(8)
        entry .ebm.tab.ebu9 -width 10 -textvariable bg_bu(9)

        bind  .ebm.tab.ebu1 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu2 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu3 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu4 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu5 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu6 <Key-Return> ApplyBodyGeometry
        bind  .ebm.tab.ebu7 <Key-Return> ApplyBodyGeometry

        grid  .ebm.tab.lbu1 -row 22 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu2 -row 23 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu3 -row 24 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu4 -row 25 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu5 -row 26 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu6 -row 27 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu7 -row 28 -column 0 -columnspan 3 -sticky w
        grid  .ebm.tab.lbu8 -row 23 -column 4 -columnspan 2 -sticky e
        grid  .ebm.tab.lbu9 -row 24 -column 4 -columnspan 2 -sticky e

        grid  .ebm.tab.ebu1 -row 22 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu2 -row 23 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu3 -row 24 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu4 -row 25 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu5 -row 26 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu6 -row 27 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu7 -row 28 -column 3 -columnspan 2 -sticky w
        grid  .ebm.tab.ebu8 -row 23 -column 6
        grid  .ebm.tab.ebu9 -row 24 -column 6

        pack  .ebm.tab .ebm.panel -side top -fill x

        ChangeIcon .ebm

    } else {
        wm deiconify .ebm
    }

    # after making window, load joint_motion.dat
    LoadJointMotionToEditor
}


# Open entries
proc EbmOpenEntries {} {
    global segm_name
    for {set i 1} {$i<=21} {incr i} {
        for {set j 1} {$j<=6} {incr j} {
            entry .ebm.tab.s${i}e$j -width 10 \
                  -textvariable bg_val(s${i}e$j)
            bind .ebm.tab.s${i}e$j <Key-Return> ApplyBodyGeometry
            grid  .ebm.tab.s${i}e$j -row $i -column $j
        }
        label .ebm.tab.s${i}l -text $segm_name($i) -anchor w
        grid  .ebm.tab.s${i}l -row $i -column 0 -sticky w
    }
}


# Load joint motion to editor
proc LoadJointMotionToEditor {} {
    # first, check body_geometry.dat file exists or not
    if { [file exists body_geometry.dat]==0 } {
        global No_body_geometry_file
        tk_messageBox -type ok -message $No_body_geometry_file \
                          -icon warning
        set bg 0
    }

    set f [open body_geometry.dat r]
    for {set i 1} {$i<=21} {incr i} {
        gets $f line
        for {set j 1} {$j<=6} {incr j} {
            global bg_val
            set bg_val(s${i}e$j) [expr [lindex $line [expr $j-1]]]
        }
    }
    for {set i 1} {$i<=9} {incr i} {
        gets $f line
        global bg_bu
        set bg_bu($i) [expr $line]
    }
    close $f
}


# Show body geometry by figure
proc ShowBodyGeometry {} {
    if {[winfo exists .sbg]==0} {

        # toplevel window
        toplevel .sbg
        wm title .sbg "Swumsuit: Body Geometry Figure"

        # Togl window
        togl .sbg.togl -width 500 -height 500 -rgba true \
             -double true -depth true -privatecmap false -time 100 
        bind .sbg.togl <ButtonPress-1> {SbgRotStart %x %y %W}
        bind .sbg.togl <B1-Motion> {SbgRotMove %x %y %W}
        bind .sbg.togl <ButtonPress-3> {SbgRotStartZ %y %W}
        bind .sbg.togl <B3-Motion> {SbgRotMoveZ %y %W}
        place .sbg.togl -x 1 -y 1

        # Axes window
        frame .sbg.axes -relief groove -bd 2
        canvas .sbg.axes.c1 -width 50 -height 9
        canvas .sbg.axes.c2 -width 50 -height 9
        canvas .sbg.axes.c3 -width 50 -height 9
        .sbg.axes.c1 create line 0 5 50 5 -width 2 -fill red
        .sbg.axes.c2 create line 0 5 50 5 -width 2 -fill blue
        .sbg.axes.c3 create line 0 5 50 5 -width 2 -fill green
        label  .sbg.axes.l1 -text ":xb  "
        label  .sbg.axes.l2 -text ":yb  "
        label  .sbg.axes.l3 -text ":zb  "
        pack   .sbg.axes.l3 \
               .sbg.axes.c3 \
               .sbg.axes.l2 \
               .sbg.axes.c2 \
               .sbg.axes.l1 \
               .sbg.axes.c1 \
                     -side right

        # Panel window
        frame .sbg.panel 
        global Close
        button .sbg.panel.close -text $Close -command "wm withdraw .sbg"
        pack .sbg.panel.close -side left -pady 10 -expand 1

        pack .sbg.togl .sbg.axes .sbg.panel -side top -fill x 

        ChangeIcon .sbg

    } else {
        wm deiconify .sbg
    }
    # Store body geometry into OpenGL library and redisplay
    ApplyBodyGeometry
}


proc SbgRotStart {x y W } {
    global sbg_startx sbg_starty sbg_xangle0 sbg_yangle0 \
           sbg_xangle sbg_yangle
	set sbg_startx $x
	set sbg_starty $y
        set sbg_vPos [$W position]
	set sbg_xangle0 [lindex $sbg_vPos 0]
	set sbg_yangle0 [lindex $sbg_vPos 1]
}

proc SbgRotStartZ {y W } {
    global sbg_startz sbg_zangle0 sbg_zangle
	set sbg_startz $y
        set sbg_vPos [$W positionz]
	set sbg_zangle0 [lindex $sbg_vPos 0]
}
proc SbgRotMove {x y W} {
    global sbg_startx sbg_starty sbg_xangle0 sbg_yangle0 \
           sbg_xangle sbg_yangle
        set sbg_xangle [expr $sbg_xangle0 + ($x - $sbg_startx)  ]
        set sbg_yangle [expr $sbg_yangle0 + ($y - $sbg_starty)  ]
        $W rotate $sbg_xangle $sbg_yangle
}

proc SbgRotMoveZ {y W} {
    global sbg_startz sbg_zangle0 sbg_zangle
        set sbg_zangle [expr $sbg_zangle0 + ($y - $sbg_startz)  ]
        $W rotatez $sbg_zangle 
}


# Apply body geometry
proc ApplyBodyGeometry {} {
    if {[winfo exists .sbg]==0} {return}
    # store body geometry
    set bglist ""
    for {set i 1} {$i<=21} {incr i} {
        for {set j 1} {$j<=6} {incr j} {
            global bg_val
            lappend bglist $bg_val(s${i}e$j)
        }
    }
    for {set i 1} {$i<=9} {incr i} {
        global bg_bu
        lappend bglist $bg_bu($i)
    }

    # pass to Togl
    set cmd ".sbg.togl passbg $bglist"
    eval $cmd
    #tk_messageBox -type ok -message $cmd
}


# Save body geometry
proc SaveBodyGeometry {} {
    global bg_val bg_bu
    set f [open body_geometry.dat w]
    fconfigure $f -translation lf
    for {set i 1} {$i<=21} {incr i} {
        set line ""
        for {set j 1} {$j<=6} {incr j} {
            set line [lappend line \
                        " [string trim $bg_val(s${i}e$j) "{}"]"]
        }
        puts $f [join $line]
    }
    for {set i 1} {$i<=9} {incr i} {
        #set line [string trim $bg_bu($i) "{}"]
        set line $bg_bu($i)
        puts $f $line
    }
    close $f
    exit   
}


# Change icon
proc ChangeIcon { w } {
    global Platform sourcedir
    if {$Platform=="windows"} {
        update
        wm iconbitmap $w $sourcedir/icon_small.ico
    }
}


# Get sourcedir & dname from arguments
set sourcedir [lindex $argv 0]
set dname     [lindex $argv 1]
set Locale    [lindex $argv 2]
cd $dname

# Set environment
source $sourcedir/set_environment.tcl
# Set default font
source $sourcedir/set_default_font.tcl
# Load message catalog 
source $sourcedir/load_catalog.tcl

# Load OpenGL library
load $sourcedir/show_body_geometry[info sharedlibextension]

# Setup start
wm withdraw .
EditBodyGeometry

