########################################################################
#                                                                      #
#      Each Joint Motion Editor for Swumsuit                           #
#                                         since 2004.12.26             #
#                                         (c) Motomu Nakashima         #
########################################################################

# global initializing
set edm_num 1

# Main window
proc EditEachMotion {} {

    # get active line
    set act_line [.editjm.list index active]
    if {$act_line==""} {
        set act_line 1
    }

    set line [.editjm.list get $act_line]
    set bname [lindex $line 0]
    set sname [lindex $line 1]
    set aname [lindex $line 2]

    AskApplyToDistal $act_line
    global atd

    global edm_num num_frames
    toplevel .editejm$edm_num
    wm title .editejm$edm_num "Swumsuit: Edit Joint Motion"

    # for AnyBody
    global any_out
    if {$bname=="Y"} {
        set any_out($edm_num) 1
    } else {
        set any_out($edm_num) 0
    }

    frame  .editejm$edm_num.title 
    label  .editejm$edm_num.title.l1 -text $sname
    label  .editejm$edm_num.title.s  -width 3
    label  .editejm$edm_num.title.s2 -width 3
    label  .editejm$edm_num.title.l2 -text $aname
    global Change Anybody_output
    button .editejm$edm_num.title.b1 -text $Change \
                        -command "PopupChangeSegment $edm_num $act_line"
    button .editejm$edm_num.title.b2 -text $Change \
                        -command "PopupChangeAxis $edm_num $act_line"
    checkbutton .editejm$edm_num.title.b3 -text $Anybody_output \
                        -variable any_out($edm_num) \
                        -command "SetAnybodyOutput $edm_num $act_line"
    global Apply_distal
    checkbutton .editejm$edm_num.title.b4 -text "$Apply_distal   " \
                        -variable atd($act_line) \
                        
    pack  .editejm$edm_num.title.l1 \
          .editejm$edm_num.title.b1 \
          .editejm$edm_num.title.s  \
          .editejm$edm_num.title.l2 \
          .editejm$edm_num.title.b2 \
          .editejm$edm_num.title.s2 \
          .editejm$edm_num.title.b4 \
          .editejm$edm_num.title.b3 \
                      -side left

    global Close Apply Xmove Frame Ymove Deg Ymagnify Times Yinvert
    frame  .editejm$edm_num.panel
    button .editejm$edm_num.panel.close -text $Close \
                   -command  "CheckEJMWindowExists .editejm$edm_num"
    frame  .editejm$edm_num.panel.xmove -relief groove -bd 2
    label  .editejm$edm_num.panel.xmove.l1 -text $Xmove \
                                           -width 12 -anchor w
    label  .editejm$edm_num.panel.xmove.l2 -text $Frame \
                                           -width 10 -anchor w
    entry  .editejm$edm_num.panel.xmove.e -width 8 \
                                          -textvariable xmove$edm_num
    button .editejm$edm_num.panel.xmove.b -text $Apply \
                                 -command "Xmove $edm_num $act_line"
    frame  .editejm$edm_num.panel.ymove -relief groove -bd 2
    label  .editejm$edm_num.panel.ymove.l1 -text $Ymove \
                                           -width 12 -anchor w
    label  .editejm$edm_num.panel.ymove.l2 -text $Deg \
                                           -width 10 -anchor w
    entry  .editejm$edm_num.panel.ymove.e -width 8 \
                                          -textvariable ymove$edm_num
    button .editejm$edm_num.panel.ymove.b -text $Apply \
                                 -command "Ymove $edm_num $act_line"
    frame  .editejm$edm_num.panel.ymag -relief groove -bd 2
    label  .editejm$edm_num.panel.ymag.l1 -text $Ymagnify \
                                          -width 12 -anchor w
    label  .editejm$edm_num.panel.ymag.l2 -text $Times \
                                          -width 10 -anchor w
    entry  .editejm$edm_num.panel.ymag.e -width 8 \
                                          -textvariable ymag$edm_num
    button .editejm$edm_num.panel.ymag.b -text $Apply \
                                 -command "Ymagnify $edm_num $act_line"
    frame  .editejm$edm_num.panel.yinv -relief groove -bd 2
    label  .editejm$edm_num.panel.yinv.l1 -text $Yinvert \
                                          -width 12 -anchor w
    button .editejm$edm_num.panel.yinv.b -text $Apply \
                                 -command "Yinvert $edm_num $act_line"

    global xmove$edm_num ymove$edm_num ymag$edm_num
    set xmove$edm_num 0
    set ymove$edm_num 0.0
    set ymag$edm_num  1.0

    pack .editejm$edm_num.panel.xmove.l1 \
         .editejm$edm_num.panel.xmove.e  \
         .editejm$edm_num.panel.xmove.l2 \
         .editejm$edm_num.panel.xmove.b  \
             -side left
    pack .editejm$edm_num.panel.ymove.l1 \
         .editejm$edm_num.panel.ymove.e  \
         .editejm$edm_num.panel.ymove.l2 \
         .editejm$edm_num.panel.ymove.b  \
             -side left
    pack .editejm$edm_num.panel.ymag.l1 \
         .editejm$edm_num.panel.ymag.e  \
         .editejm$edm_num.panel.ymag.l2 \
         .editejm$edm_num.panel.ymag.b  \
             -side left
    pack .editejm$edm_num.panel.yinv.l1 \
         .editejm$edm_num.panel.yinv.b  \
             -side left
    pack .editejm$edm_num.panel.xmove \
         .editejm$edm_num.panel.ymove \
         .editejm$edm_num.panel.ymag  \
         .editejm$edm_num.panel.yinv  \
             -side top -fill x
    pack .editejm$edm_num.panel.close -side top -pady 10


    frame .editejm$edm_num.value -relief groove -bd 2
    frame .editejm$edm_num.value.label
    global Frame Angle_deg
    label .editejm$edm_num.value.label.1 -text $Frame -width 8
    label .editejm$edm_num.value.label.2 -text $Angle_deg -width 12
    text .editejm$edm_num.value.text -height 20 -width 22 \
              -insertwidth 0 -wrap none -relief flat \
              -highlightthickness 0 -bd 0 -autoseparators 0 \
              -yscrollcommand ".editejm$edm_num.value.sc set"
    scrollbar .editejm$edm_num.value.sc -orient vertical \
                   -command ".editejm$edm_num.value.text yview"
    button .editejm$edm_num.value.b -text $Apply \
                   -command "EachMotionEntryApply $edm_num $act_line"
    
    
    # make labels and entrys and embed them into the text widget
    set x ""
    set y ""


    for {set i 1} {$i<=$num_frames} {incr i} {
        # labels
        label .editejm$edm_num.value.text.l$i -width 8 \
                -borderwidth 2 -relief flat -text "[expr $i-1]/$num_frames :"
        .editejm$edm_num.value.text window create end \
                       -window .editejm$edm_num.value.text.l$i
        # entrys
        global ejm_val${edm_num}_$i
        entry .editejm$edm_num.value.text.e$i -width 12 \
             -borderwidth 1 -textvariable ejm_val${edm_num}_$i -bg white
        .editejm$edm_num.value.text window create end \
                       -window .editejm$edm_num.value.text.e$i
        # entry binding
        bind .editejm$edm_num.value.text.e$i <Key-Return> \
                        "EachMotionEntryApply $edm_num $act_line"
        bind .editejm$edm_num.value.text.e$i <Key-Up> \
                        "MoveUpCursor $edm_num $i"
        bind .editejm$edm_num.value.text.e$i <Key-Down> \
                        "MoveDownCursor $edm_num $i"

        # blank labels
        label .editejm$edm_num.value.text.b$i -width 8 \
                -borderwidth 1 -relief flat -text "    "
        .editejm$edm_num.value.text window create end \
                       -window .editejm$edm_num.value.text.b$i

        .editejm$edm_num.value.text insert end "\n"

        # substitute values
        set ejm_val${edm_num}_$i   [lindex $line [expr $i+2]]
        set ejm_val_cur($i) [lindex $line [expr $i+2]]
  
    }
    .editejm$edm_num.value.text delete end-1chars end
    
    # make data for graph
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i-$num_frames-1]] 
        set y [lappend y "$ejm_val_cur($i)"]
    }
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i-1]] 
        set y [lappend y "$ejm_val_cur($i)"]
    }
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i+$num_frames-1]] 
        set y [lappend y "$ejm_val_cur($i)"]
    }


    # draw graph using BLT
    package require BLT
    catch { namespace import blt::* }
    vector vx$edm_num vy$edm_num
    vx$edm_num set $x
    vy$edm_num set $y
    #graph .editejm$edm_num.graph -width 4i -height 3i 
    graph .editejm$edm_num.graph -width 300 -height 225 \
                                 -relief groove -bd 2
    # draw graph
    .editejm$edm_num.graph element create line1 \
           -xdata vx$edm_num -ydata vy$edm_num -label ""  \
           -smooth natural -pixels 4 
    # x-axis configuration
    set majorticks "0"
    set minorticks "0"
    for {set i 1} {$i<=$num_frames} {incr i} {
        #set minorticks [lappend minorticks $i] 
        set minorticks [lappend minorticks [expr $i/$num_frames]] 
    }
    global Frame Angle_deg
    .editejm$edm_num.graph axis configure x -min 0 -max $num_frames \
                    -minorticks "0.2 0.4 0.6 0.8" -title $Frame
    .editejm$edm_num.graph axis configure y -title $Angle_deg


    pack .editejm$edm_num.value.label.1 \
         .editejm$edm_num.value.label.2 \
              -side left
    pack .editejm$edm_num.value.label -side top -anchor w

    pack .editejm$edm_num.value.b -side bottom -pady 5
    pack .editejm$edm_num.value.text \
         .editejm$edm_num.value.sc \
              -side left -fill y

    grid .editejm$edm_num.title -row 0 -column 0 -columnspan 2 \
                                -sticky ns -pady 5
    grid .editejm$edm_num.value -row 1 -column 0 -rowspan 2 -sticky ns
    grid .editejm$edm_num.graph -row 1 -column 1 -sticky n
    grid .editejm$edm_num.panel -row 2 -column 1 -sticky wes
    grid rowconfigure    .editejm$edm_num 1 -weight 100
    grid columnconfigure .editejm$edm_num 1 -weight 100

    # Disable editing buttons (cut, copy, paste...)
    .editjm.frame.create configure -state disabled
    .editjm.frame.cut    configure -state disabled
    .editjm.frame.copy   configure -state disabled
    .editjm.frame.paste  configure -state disabled
    wm protocol .editejm$edm_num WM_DELETE_WINDOW "CheckEJMWindowExists .editejm$edm_num"

    ChangeIcon .editejm$edm_num

    incr edm_num

    # re-hilight
    UnHilightSegEntry
    HilightSegEntry
}


# Move up cursor at entry
proc MoveUpCursor { edm_num i } {
    if {$i!=1} {
        focus .editejm$edm_num.value.text.e[expr $i-1]
    }
}


# Move down cursor at entry
proc MoveDownCursor { edm_num i } {
    global num_frames
    if {$i!=$num_frames} {
        focus .editejm$edm_num.value.text.e[expr $i+1]
    }
}


# Check all ejm windows exist or not
# (for detele button of window bar)
proc CheckEJMWindowExists { W } {
    global edm_num
    # withdraw the window
    wm withdraw $W

    # check any windows remain open or not
    set check 0
    for {set j 1} {$j<$edm_num} {incr j} {
        set check2 [wm state .editejm$j]
        if {$check2!="withdrawn"} { set check [expr $check +1] }
    }

    # If there are no each joint motion windows, enable editing buttons.
    if {$check=="0"} {
        .editjm.frame.create configure -state normal
        .editjm.frame.cut    configure -state normal
        .editjm.frame.copy   configure -state normal
        .editjm.frame.paste  configure -state normal
    }
}


# X Move
proc Xmove { edm_num act_line } {
    global num_frames

    # change entry values
    set xmove [expr int([.editejm$edm_num.panel.xmove.e get])]

    for {set i 1} {$i<=$num_frames} {incr i} {
        set val($i) [.editejm$edm_num.value.text.e$i get]
        set val([expr $i+$num_frames]) $val($i)
        set val([expr $i-$num_frames]) $val($i)
    }

    for {set i 1} {$i<=$num_frames} {incr i} {
        global ejm_val${edm_num}_$i
        set ejm_val${edm_num}_$i $val([expr $i-$xmove])
    }

    # change all list values
    ChangeAllListValues $edm_num $act_line

    # change joint motion graph
    ChangeJointMotionGraph $edm_num

    # change animation (if animation window exists)
    #if {[winfo exists .ajm]==1} { StoreJointMotion }
    StoreJointMotion
    IISwimmerUpdate
}


# Y Move
proc Ymove { edm_num act_line } {
    global num_frames

    # change entry values
    set ymove [.editejm$edm_num.panel.ymove.e get]
    for {set i 1} {$i<=$num_frames} {incr i} {
        set val [.editejm$edm_num.value.text.e$i get]
        global ejm_val${edm_num}_$i
        set ejm_val${edm_num}_$i [expr $val + $ymove]
    }

    # change all list values
    ChangeAllListValues $edm_num $act_line

    # change joint motion graph
    ChangeJointMotionGraph $edm_num

    # change animation (if animation window exists)
    #if {[winfo exists .ajm]==1} { StoreJointMotion }
    StoreJointMotion
    IISwimmerUpdate
}


# Y Magnify
proc Ymagnify { edm_num act_line } {
    global num_frames

    # change entry values
    set ymag [.editejm$edm_num.panel.ymag.e get]
    for {set i 1} {$i<=$num_frames} {incr i} {
        set val [.editejm$edm_num.value.text.e$i get]
        global ejm_val${edm_num}_$i
        set ejm_val${edm_num}_$i [expr $val*$ymag]
    }

    # change all list values
    ChangeAllListValues $edm_num $act_line

    # change joint motion graph
    ChangeJointMotionGraph $edm_num

    # change animation (if animation window exists)
    #if {[winfo exists .ajm]==1} { StoreJointMotion }
    StoreJointMotion
    IISwimmerUpdate
}


# Y Invert
proc Yinvert { edm_num act_line } {
    global num_frames

    # change entry values
    set ymag [.editejm$edm_num.panel.ymag.e get]
    for {set i 1} {$i<=$num_frames} {incr i} {
        set val [.editejm$edm_num.value.text.e$i get]
        global ejm_val${edm_num}_$i
        set ejm_val${edm_num}_$i  [expr -$val]
    }

    # change all list values
    ChangeAllListValues $edm_num $act_line

    # change joint motion graph
    ChangeJointMotionGraph $edm_num

    # change animation (if animation window exists)
    #if {[winfo exists .ajm]==1} { StoreJointMotion }
    StoreJointMotion
    IISwimmerUpdate
}


# Apply entry values 
proc EachMotionEntryApply { edm_num act_line } {
    # change all list values
    ChangeAllListValues $edm_num $act_line

    # change joint motion graph
    ChangeJointMotionGraph $edm_num

    # change animation (if animation window exists)
    #if {[winfo exists .ajm]==1} { StoreJointMotion }
    StoreJointMotion
    IISwimmerUpdate
}

# Change all list values into entry values
proc ChangeAllListValues { edm_num act_line } {
    global num_frames

    # save selection
    set sel [.editjm.list curselection]

    set line [.editjm.list get $act_line]
    .editjm.list delete $act_line
    set ins_text "[lindex $line 0]  [lindex $line 1]  [lindex $line 2]  "

    for {set i 1} {$i<=$num_frames} {incr i} {
        global ejm_val${edm_num}_$i
        set ins_text "$ins_text  [.editejm$edm_num.value.text.e$i get]"
    }
    .editjm.list insert $act_line $ins_text

    # if "apply to distal" is yes, change for distal segments as well
    global atd
    global same_rotation
    if {$atd($act_line)==1} {
        #CheckSameRotation $act_line
        foreach j $same_rotation($act_line) {
            set line [.editjm.list get $j]
            .editjm.list delete $j
            set ins_text "[lindex $line 0]  [lindex $line 1]  [lindex $line 2]  "

            for {set i 1} {$i<=$num_frames} {incr i} {
                global ejm_val${edm_num}_$i
                set ins_text "$ins_text  [.editejm$edm_num.value.text.e$i get]"
            }
            .editjm.list insert $j $ins_text
        }
    }

    # set selection again
    if {$sel==""} { return }
    foreach  i  $sel {
        .editjm.list selection set $i
    }
}


# Change joint motion graph
proc ChangeJointMotionGraph { edm_num } {
    global num_frames

    set x ""
    set y ""
     # make data for graph
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i-$num_frames-1]] 
        set y [lappend y [.editejm$edm_num.value.text.e$i get]]
    }
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i-1]] 
        set y [lappend y [.editejm$edm_num.value.text.e$i get]]
    }
    for {set i 1} {$i<=$num_frames} {incr i} {
        set x [lappend x [expr $i+$num_frames-1]] 
        set y [lappend y [.editejm$edm_num.value.text.e$i get]]
    }

    vector vx$edm_num vy$edm_num
    vx$edm_num set $x
    vy$edm_num set $y
    # redraw graph
    .editejm$edm_num.graph element configure line1 \
           -xdata vx$edm_num -ydata vy$edm_num 

    # re-hilight
    UnHilightSegEntry
    HilightSegEntry
}


# Popup change segment window
proc PopupChangeSegment { edm_num act_line } {
    if {[winfo exists .editejm$edm_num.cs]==0} {
        toplevel .editejm$edm_num.cs
        wm title .editejm$edm_num.cs "Swumsuit: Change Segment"

        frame   .editejm$edm_num.cs.l
        listbox .editejm$edm_num.cs.l.l \
                      -yscrollcommand ".editejm$edm_num.cs.l.s set" \
                      -exportselection false
        scrollbar .editejm$edm_num.cs.l.s \
                      -command ".editejm$edm_num.cs.l.l yview"

        pack .editejm$edm_num.cs.l.l -side left
        pack .editejm$edm_num.cs.l.s -side left -fill y
        pack .editejm$edm_num.cs.l

        frame .editejm$edm_num.cs.p
        global OK Cancel
        button .editejm$edm_num.cs.p.ok -text $OK \
                      -command "ChangeSegment $edm_num $act_line"
        button .editejm$edm_num.cs.p.cancel -text $Cancel \
                      -command "wm withdraw .editejm$edm_num.cs"
        pack .editejm$edm_num.cs.p.ok \
             .editejm$edm_num.cs.p.cancel \
                 -pady 10 -side left -expand 1

        pack .editejm$edm_num.cs.l \
             .editejm$edm_num.cs.p -side top -fill x

        ChangeIcon .editejm$edm_num.cs
    } else {
        wm deiconify .editejm$edm_num.cs
    }

    set line [.editjm.list get $act_line]
    set sname [lindex $line 1]

    global segm_name Local_blank
    .editejm$edm_num.cs.l.l delete 0 end
    # insert segment name into listbox
    for {set j 1} {$j<=21} {incr j} {
        .editejm$edm_num.cs.l.l insert end $segm_name($j)
        set a1 [string trim [string trim $segm_name($j)] $Local_blank]
        set a2 [string trim [string trim $sname] $Local_blank]
        if {$a1==$a2} { set snum $j }
    }
    .editejm$edm_num.cs.l.l selection set [expr $snum-1]
    .editejm$edm_num.cs.l.l see [expr $snum-1]
}


# Change segment
proc ChangeSegment { edm_num act_line } {
    set line [.editjm.list get $act_line]
    set anybody_flag  [lindex $line 0]
    set seg  [lindex $line 1]
    set line2 [string trimleft $line $anybody_flag]
    set line3 [string trimleft $line2 " "]
    set line4 [string trimleft $line3 $seg]

    set snum [expr [.editejm$edm_num.cs.l.l curselection ]+1]

    global segm_name
    set ins_text "$anybody_flag  $segm_name($snum)$line4"
    .editjm.list delete $act_line
    .editjm.list insert $act_line $ins_text

    .editejm$edm_num.title.l1 configure -text $segm_name($snum)

    wm withdraw .editejm$edm_num.cs 

    StoreJointMotion
    IISwimmerUpdate

    .editjm.list selection clear 0 end
    .editjm.list selection set $act_line $act_line
}


# Popup change axis window
proc PopupChangeAxis { edm_num act_line } {
    if {[winfo exists .editejm$edm_num.ca]==0} {
        toplevel .editejm$edm_num.ca
        wm title .editejm$edm_num.ca "Swumsuit: Change Axis"

        frame   .editejm$edm_num.ca.l
        listbox .editejm$edm_num.ca.l.l \
                      -yscrollcommand ".editejm$edm_num.ca.l.s set" \
                      -exportselection false
        scrollbar .editejm$edm_num.ca.l.s \
                      -command ".editejm$edm_num.ca.l.l yview"

        pack .editejm$edm_num.ca.l.l -side left
        pack .editejm$edm_num.ca.l.s -side left -fill y
        pack .editejm$edm_num.ca.l

        frame .editejm$edm_num.ca.p
        global OK Cancel
        button .editejm$edm_num.ca.p.ok -text $OK \
                      -command "ChangeAxis $edm_num $act_line"
        button .editejm$edm_num.ca.p.cancel -text $Cancel \
                      -command "wm withdraw .editejm$edm_num.ca"
        pack .editejm$edm_num.ca.p.ok \
             .editejm$edm_num.ca.p.cancel \
                 -pady 10 -side left -expand 1

        pack .editejm$edm_num.ca.l \
             .editejm$edm_num.ca.p -side top -fill x

        ChangeIcon .editejm$edm_num.ca
    } else {
        wm deiconify .editejm$edm_num.ca
    }

    set line [.editjm.list get $act_line]
    set aname [lindex $line 2]

    global axis_name
    .editejm$edm_num.ca.l.l delete 0 end
    # insert axis name into listbox
    for {set j 1} {$j<=9} {incr j} {
        .editejm$edm_num.ca.l.l insert end $axis_name($j)
        set a1 [string trim $axis_name($j)]
        set a2 [string trim $aname]
        if {$a1==$a2} { set anum $j }
    }
    .editejm$edm_num.ca.l.l selection set [expr $anum-1]
    .editejm$edm_num.ca.l.l see [expr $anum-1]
}


# Change axis
proc ChangeAxis { edm_num act_line } {
    set line [.editjm.list get $act_line]
    set anybody_flag  [lindex $line 0]
    set seg   [lindex $line 1]
    set axis  [lindex $line 2]
    set line2 [string trimleft $line $anybody_flag]
    set line3 [string trimleft $line2 " "]
    set line4 [string trimleft $line3 $seg]
    global Local_blank
    set line5 [string trimleft [string trimleft $line4 $Local_blank]]
    set line6 [string trimleft $line5 $axis]

    set anum [expr [.editejm$edm_num.ca.l.l curselection ]+1]

    global segm_name
    for {set j 1} {$j<=21} {incr j} {
        set a1 [string trim [string trim $segm_name($j)] $Local_blank]
        set a2 [string trim [string trim $seg] $Local_blank]
        if {$a1==$a2} { set snum $j }
    }
    
    global axis_name
    set ins_text "$anybody_flag  $segm_name($snum)  $axis_name($anum)$line6"
    .editjm.list delete $act_line
    .editjm.list insert $act_line $ins_text

    .editejm$edm_num.title.l2 configure -text $axis_name($anum)

    wm withdraw .editejm$edm_num.ca

    StoreJointMotion
    IISwimmerUpdate

    .editjm.list selection clear 0 end
    .editjm.list selection set $act_line $act_line
}


# Set Anybody output
proc SetAnybodyOutput { edm_num act_line } {
    global any_out
    set a $any_out($edm_num)
    set line [.editjm.list get $act_line]
    set line [string trimleft $line YN]
    if {$a=="1"} {
        set line "Y$line"
    } else {
        set line "N$line"
    }
    .editjm.list delete $act_line
    .editjm.list insert $act_line $line
    # re-activate line in the list
    .editjm.list selection set $act_line
}


# Check samae rotation
proc CheckSameRotation { act_line } {
    global edm_num num_frames 
    global num_line
    global segm_num_a
    global axis_num_a
    global joint_angle_a
    global right_elevation left_elevation
    global same_rotation

    StoreJointMotion

    set same_rotation($act_line) ""

    if {$segm_num_a($act_line)=="1"} {
    # Lower waist
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==2)||($segm_num_a($i)==3)||($segm_num_a($i)==4) \
          ||($segm_num_a($i)==5)||($segm_num_a($i)==6)||($segm_num_a($i)==7) \
          ||($segm_num_a($i)==16)||($segm_num_a($i)==17)||($segm_num_a($i)==18) \
          ||($segm_num_a($i)==19)||($segm_num_a($i)==20)||($segm_num_a($i)==21) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="2"} {
    # Upper waist
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==3)||($segm_num_a($i)==4) \
          ||($segm_num_a($i)==5)||($segm_num_a($i)==6)||($segm_num_a($i)==7) \
          ||($segm_num_a($i)==16)||($segm_num_a($i)==17)||($segm_num_a($i)==18) \
          ||($segm_num_a($i)==19)||($segm_num_a($i)==20)||($segm_num_a($i)==21) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="3"} {
    # Lower breast
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==4) \
          ||($segm_num_a($i)==5)||($segm_num_a($i)==6)||($segm_num_a($i)==7) \
          ||($segm_num_a($i)==16)||($segm_num_a($i)==17)||($segm_num_a($i)==18) \
          ||($segm_num_a($i)==19)||($segm_num_a($i)==20)||($segm_num_a($i)==21) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="4"} {
    # Upper breast
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==5)||($segm_num_a($i)==6)||($segm_num_a($i)==7) \
          ||($segm_num_a($i)==16)||($segm_num_a($i)==17)||($segm_num_a($i)==18) \
          ||($segm_num_a($i)==19)||($segm_num_a($i)==20)||($segm_num_a($i)==21) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="5"} {
    # Shoulder
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==6)||($segm_num_a($i)==7)} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="6"} {
    # Neck
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {$segm_num_a($i)==7} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="8"} {
    # Upper hip
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==9)||($segm_num_a($i)==10)||($segm_num_a($i)==11) \
          ||($segm_num_a($i)==12)||($segm_num_a($i)==13)||($segm_num_a($i)==14) \
          ||($segm_num_a($i)==15) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="9"} {
    # Lower hip
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==10)||($segm_num_a($i)==11) \
          ||($segm_num_a($i)==12)||($segm_num_a($i)==13)||($segm_num_a($i)==14) \
          ||($segm_num_a($i)==15) } {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="10"} {
    # Right thigh
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==12)||($segm_num_a($i)==14)} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="11"} {
    # Left thigh
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==13)||($segm_num_a($i)==15)} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="12"} {
    # Right shank
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {$segm_num_a($i)==14} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="13"} {
    # Left shank
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {$segm_num_a($i)==15} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="16"} {
    # Right upper arm
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==18)||($segm_num_a($i)==20)} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="17"} {
    # Left upper arm
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {($segm_num_a($i)==19)||($segm_num_a($i)==21)} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="18"} {
    # Right forearm
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {$segm_num_a($i)==20} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    } elseif {$segm_num_a($act_line)=="19"} {
    # Left forearm
    for {set i 0} {$i<=[expr $num_line -1]} {incr i} {
        if {$segm_num_a($i)==21} {
            if {$axis_num_a($i)==$axis_num_a($act_line)} {
                set flag 0
                for {set j 0} {$j<=[expr $num_frames -1]} {incr j} {
                    if {[expr abs($joint_angle_a($i,$j) \
                                 -$joint_angle_a($act_line,$j)) > 0.1]==1} {
                        set flag 1
                    }
                }
                if {$flag=="0"} {
                    lappend same_rotation($act_line) $i
                }
            }
        }
    }

    }
    #tk_messageBox -message "same rotation [lindex $same_rotation($act_line)]"
}


# Ask apply to distal or not
proc AskApplyToDistal { act_line } {
    global edm_num num_frames 
    global num_line
    global segm_num_a
    global axis_num_a
    global joint_angle_a
    global right_elevation left_elevation
    global same_rotation

    CheckSameRotation $act_line
    #tk_messageBox -message "same rotation [lindex $same_rotation($act_line)]"

    if {$same_rotation($act_line)!=""} {
        global segm_name
        set appendmessage ""
        foreach i $same_rotation($act_line) {
            set appendmessage "$appendmessage
            $segm_name($segm_num_a($i))"
        }

        global ApplyToDistal
        set yesno [tk_messageBox -type yesno -message "$ApplyToDistal \n $appendmessage" ]
        global atd
        set atd($act_line) 0
        if {$yesno=="yes"} {set atd($act_line) 1}
    }
}

